/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.util;

import com.blankj.utilcode.util.LogUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001J(\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000f\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\n0\rJ'\u0010\u0012\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\n0\r\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lx/aichen/util/JsonUtil;", "", "()V", "gson", "Lcom/google/gson/Gson;", "ObjToString", "", "obj", "Object2List", "Ljava/util/ArrayList;", "T", "jsonString", "cls", "Ljava/lang/Class;", "StringToList", "", "str", "beanObj", "StringToObj", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getGson", "util_release"})
public final class JsonUtil {
    private static Gson gson;
    public static final JsonUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Gson getGson() {
        if (gson == null) {
            Class<JsonUtil> clazz = JsonUtil.class;
            synchronized (clazz) {
                if (gson == null) {
                    gson = new Gson();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Gson gson = JsonUtil.gson;
        if (gson == null) {
            Intrinsics.throwNpe();
        }
        return gson;
    }

    public final <T> T StringToObj(@NotNull String str, @NotNull Class<T> beanObj) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull(beanObj, (String)"beanObj");
        Object json = null;
        try {
            json = this.getGson().fromJson(str, beanObj);
        }
        catch (Exception ex) {
            LogUtils.e((Object[])new Object[]{ex});
        }
        Object object = json;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (T)object;
    }

    @NotNull
    public final <T> List<T> StringToList(@NotNull String str, @NotNull Class<T> beanObj) {
        Object fromJson2;
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        Intrinsics.checkParameterIsNotNull(beanObj, (String)"beanObj");
        Type type2 = new TypeToken<List<? extends T>>(){}.getType();
        Gson gson = JsonUtil.gson;
        if (gson == null) {
            Intrinsics.throwNpe();
        }
        Object object = fromJson2 = gson.fromJson(str, type2);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<T>");
        }
        List list = (List)object;
        return list;
    }

    @NotNull
    public final <T> ArrayList<T> Object2List(@NotNull String jsonString, @NotNull Class<T> cls) {
        Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
        Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Gson gson = new Gson();
            JsonElement jsonElement = new JsonParser().parse(jsonString);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"JsonParser().parse(jsonString)");
            JsonArray arry = jsonElement.getAsJsonArray();
            for (JsonElement jsonElement2 : arry) {
                list.add(gson.fromJson(jsonElement2, cls));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @NotNull
    public final String ObjToString(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String string = this.getGson().toJson(obj);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getGson().toJson(obj)");
        return string;
    }

    private JsonUtil() {
    }

    static {
        JsonUtil jsonUtil;
        INSTANCE = jsonUtil = new JsonUtil();
    }
}

