/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.sonic;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.webkit.JavascriptInterface;
import com.tencent.sonic.sdk.SonicDiffDataCallback;
import org.json.JSONObject;
import x.aichen.sonic.SonicSessionClientImpl;

public class SonicJavaScriptInterface {
    private final SonicSessionClientImpl sessionClient;
    private final Intent intent;
    public static final String PARAM_CLICK_TIME = "clickTime";
    public static final String PARAM_LOAD_URL_TIME = "loadUrlTime";

    public SonicJavaScriptInterface(SonicSessionClientImpl sessionClient, Intent intent) {
        this.sessionClient = sessionClient;
        this.intent = intent;
    }

    @JavascriptInterface
    public void getDiffData() {
        this.getDiffData2("getDiffDataCallback");
    }

    @JavascriptInterface
    public void getDiffData2(final String jsCallbackFunc) {
        Log.i((String)"Info", (String)"getDiffData2");
        if (null != this.sessionClient) {
            this.sessionClient.getDiffData(new SonicDiffDataCallback(){

                public void callback(final String resultData) {
                    Runnable callbackRunnable = new Runnable(){

                        @Override
                        public void run() {
                            String jsCode = "javascript:" + jsCallbackFunc + "('" + SonicJavaScriptInterface.toJsString(resultData) + "')";
                            SonicJavaScriptInterface.this.sessionClient.getWebView().loadUrl(jsCode);
                        }
                    };
                    if (Looper.getMainLooper() == Looper.myLooper()) {
                        callbackRunnable.run();
                    } else {
                        new Handler(Looper.getMainLooper()).post(callbackRunnable);
                    }
                }
            });
        }
    }

    @JavascriptInterface
    public String getPerformance() {
        long clickTime = this.intent.getLongExtra(PARAM_CLICK_TIME, -1L);
        long loadUrlTime = this.intent.getLongExtra(PARAM_LOAD_URL_TIME, -1L);
        try {
            JSONObject result = new JSONObject();
            result.put(PARAM_CLICK_TIME, clickTime);
            result.put(PARAM_LOAD_URL_TIME, loadUrlTime);
            Log.i((String)"Info", (String)"getPerformance");
            return result.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String toJsString(String value) {
        if (value == null) {
            return "null";
        }
        StringBuilder out = new StringBuilder(1024);
        int length = value.length();
        block8: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                case '\t': {
                    out.append("\\t");
                    continue block8;
                }
                case '\b': {
                    out.append("\\b");
                    continue block8;
                }
                case '\n': {
                    out.append("\\n");
                    continue block8;
                }
                case '\r': {
                    out.append("\\r");
                    continue block8;
                }
                case '\f': {
                    out.append("\\f");
                    continue block8;
                }
                default: {
                    if (c <= '\u001f') {
                        out.append(String.format("\\u%04x", c));
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }
}

