/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.http.interceptor;

import androidx.annotation.NonNull;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import x.aichen.http.body.UploadProgressRequestBody;
import x.aichen.http.callback.UCallback;

public class UploadProgressInterceptor
implements Interceptor {
    private UCallback callback;

    public UploadProgressInterceptor(UCallback callback) {
        this.callback = callback;
        if (callback == null) {
            throw new NullPointerException("this callback must not null.");
        }
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (originalRequest.body() == null) {
            return chain.proceed(originalRequest);
        }
        Request progressRequest = originalRequest.newBuilder().method(originalRequest.method(), (RequestBody)new UploadProgressRequestBody(originalRequest.body(), this.callback)).build();
        return chain.proceed(progressRequest);
    }
}

