/*
 * Decompiled with CFR 0.152.
 */
package x.aichen.views.auto;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.design.widget.TabLayout;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zhy.autolayout.utils.AutoUtils;
import com.zhy.autolayout.utils.DimenUtils;
import x.aichen.R;

public class AutoTabLayout
extends TabLayout {
    private static final int NO_VALID = -1;
    private int mTextSize;
    private boolean mTextSizeBaseWidth = false;

    public AutoTabLayout(Context context) {
        this(context, null);
    }

    public AutoTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTextSizeBaseWidth(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabLayout, defStyleAttr, R.style.Widget_Design_TabLayout);
        int tabTextAppearance = a.getResourceId(R.styleable.TabLayout_tabTextAppearance, R.style.TextAppearance_Design_Tab);
        this.mTextSize = this.loadTextSizeFromTextAppearance(tabTextAppearance);
        a.recycle();
    }

    private void initTextSizeBaseWidth(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AutoTabLayout);
        this.mTextSizeBaseWidth = a.getBoolean(R.styleable.AutoTabLayout_auto_textSize_base_width, false);
        a.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadTextSizeFromTextAppearance(int textAppearanceResId) {
        TypedArray a = this.getContext().obtainStyledAttributes(textAppearanceResId, R.styleable.TextAppearance);
        try {
            if (!DimenUtils.isPxVal((TypedValue)a.peekValue(R.styleable.TextAppearance_android_textSize))) {
                int n = -1;
                return n;
            }
            int n = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, -1);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public void addTab(TabLayout.Tab tab, int position, boolean setSelected) {
        super.addTab(tab, position, setSelected);
        this.setUpTabTextSize(tab);
    }

    public void addTab(TabLayout.Tab tab, boolean setSelected) {
        super.addTab(tab, setSelected);
        this.setUpTabTextSize(tab);
    }

    private void setUpTabTextSize(TabLayout.Tab tab) {
        if (this.mTextSize == -1 || tab.getCustomView() != null) {
            return;
        }
        ViewGroup tabGroup = (ViewGroup)this.getChildAt(0);
        ViewGroup tabContainer = (ViewGroup)tabGroup.getChildAt(tab.getPosition());
        TextView textView = (TextView)tabContainer.getChildAt(1);
        if (AutoUtils.autoed((View)textView)) {
            return;
        }
        int autoTextSize = 0;
        autoTextSize = this.mTextSizeBaseWidth ? AutoUtils.getPercentWidthSize((int)this.mTextSize) : AutoUtils.getPercentHeightSize((int)this.mTextSize);
        textView.setTextSize(0, (float)autoTextSize);
    }
}

