package x.aichen.base

import android.content.Context
import android.os.Bundle
import android.util.AttributeSet
import android.view.View
import com.blankj.utilcode.util.KeyboardUtils
import com.trello.rxlifecycle2.components.support.RxAppCompatActivity
import com.zhy.autolayout.AutoFrameLayout
import com.zhy.autolayout.AutoLinearLayout
import com.zhy.autolayout.AutoRelativeLayout


/**
 * author 艾晨
 * Created at 2017/3/25 16:59
 * Update at 2017/3/25 16:59
 * Update people:
 * Version:1.1
 * 说明：
 */

abstract class XBaseActivity : RxAppCompatActivity() {
    protected abstract val layooutid: Int
    protected abstract fun initView(savedInstanceState: Bundle?)
    protected abstract fun initListener()
    protected abstract fun initDate()
    override fun onCreateView(name: String, context: Context, attrs: AttributeSet): View? {
        var view: View? = null
        if (name == LAYOUT_FRAMELAYOUT) {
            view = AutoFrameLayout(context, attrs)
        }

        if (name == LAYOUT_LINEARLAYOUT) {
            view = AutoLinearLayout(context, attrs)
        }

        if (name == LAYOUT_RELATIVELAYOUT) {
            view = AutoRelativeLayout(context, attrs)
        }
        if (view != null) return view

        return super.onCreateView(name, context, attrs)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        initFirst()
        super.onCreate(savedInstanceState)
        setContentView(layooutid)
        initView(savedInstanceState)
        initAfterViewPrepared()
        initListener()
        initDate()
    }

    protected open fun initFirst() {
    }

    protected fun initAfterViewPrepared() {

    }


    override fun onDestroy() {
        KeyboardUtils.fixSoftInputLeaks(this)  //修复键盘内存泄漏的     无用
        super.onDestroy()
    }

    companion object {
        //生命周期管理
        private val LAYOUT_LINEARLAYOUT = "LinearLayout"
        private val LAYOUT_FRAMELAYOUT = "FrameLayout"
        private val LAYOUT_RELATIVELAYOUT = "RelativeLayout"
    }
}
