/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.workers.WorkAction;
import wtf.emulator.EwWorkParameters;
import wtf.emulator.OutputType;

public abstract class EwWorkAction
implements WorkAction<EwWorkParameters> {
    @Inject
    public abstract ExecOperations getExecOperations();

    public void execute() {
        String token = (String)((EwWorkParameters)this.getParameters()).getToken().getOrNull();
        if (token == null) {
            throw new IllegalArgumentException("Missing token for emulator.wtf.\nDid you forget to set token in the emulatorwtf {} block or EW_API_TOKEN env var?");
        }
        try {
            ExecOperations exec = this.getExecOperations();
            ExecResult result = exec.javaexec(spec -> {
                List dirsToPull;
                Map env;
                Set additionalApks;
                spec.environment("EW_API_TOKEN", (Object)token);
                spec.classpath(new Object[]{((EwWorkParameters)this.getParameters()).getClasspath().get()});
                if (((EwWorkParameters)this.getParameters()).getLibraryTestApk().isPresent()) {
                    spec.args(new Object[]{"--library-test", ((RegularFile)((EwWorkParameters)this.getParameters()).getLibraryTestApk().get()).getAsFile().getAbsolutePath()});
                } else {
                    spec.args(new Object[]{"--app", ((RegularFile)((EwWorkParameters)this.getParameters()).getAppApk().get()).getAsFile().getAbsolutePath()});
                    spec.args(new Object[]{"--test", ((RegularFile)((EwWorkParameters)this.getParameters()).getTestApk().get()).getAsFile().getAbsolutePath()});
                }
                if (((EwWorkParameters)this.getParameters()).getOutputsDir().isPresent()) {
                    spec.args(new Object[]{"--outputs-dir", ((Directory)((EwWorkParameters)this.getParameters()).getOutputsDir().get()).getAsFile().getAbsolutePath()});
                }
                if (((EwWorkParameters)this.getParameters()).getOutputs().isPresent() && !((List)((EwWorkParameters)this.getParameters()).getOutputs().get()).isEmpty()) {
                    String outputs = ((List)((EwWorkParameters)this.getParameters()).getOutputs().get()).stream().map(OutputType::getTypeName).collect(Collectors.joining(","));
                    spec.args(new Object[]{"--outputs", outputs});
                }
                if (((EwWorkParameters)this.getParameters()).getTimeout().isPresent()) {
                    spec.args(new Object[]{"--timeout", EwWorkAction.toCliString((Duration)((EwWorkParameters)this.getParameters()).getTimeout().get())});
                }
                if (((EwWorkParameters)this.getParameters()).getDevices().isPresent()) {
                    ((List)((EwWorkParameters)this.getParameters()).getDevices().get()).forEach(device -> {
                        if (!device.isEmpty()) {
                            spec.args(new Object[]{"--device", device.entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).collect(Collectors.joining(","))});
                        }
                    });
                }
                if (Boolean.TRUE.equals(((EwWorkParameters)this.getParameters()).getUseOrchestrator().getOrNull())) {
                    spec.args(new Object[]{"--use-orchestrator"});
                }
                if (Boolean.TRUE.equals(((EwWorkParameters)this.getParameters()).getClearPackageData().getOrNull())) {
                    spec.args(new Object[]{"--clear-package-data"});
                }
                if (Boolean.TRUE.equals(((EwWorkParameters)this.getParameters()).getWithCoverage().getOrNull())) {
                    spec.args(new Object[]{"--with-coverage"});
                }
                if (((EwWorkParameters)this.getParameters()).getAdditionalApks().isPresent() && !(additionalApks = ((FileCollection)((EwWorkParameters)this.getParameters()).getAdditionalApks().get()).getFiles()).isEmpty()) {
                    spec.args(new Object[]{"--additional-apks", additionalApks.stream().map(File::getAbsolutePath).collect(Collectors.joining(","))});
                }
                if (((EwWorkParameters)this.getParameters()).getEnvironmentVariables().isPresent() && !(env = (Map)((EwWorkParameters)this.getParameters()).getEnvironmentVariables().get()).isEmpty()) {
                    String envLine = env.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
                    spec.args(new Object[]{"--environment-variables", envLine});
                }
                if (((EwWorkParameters)this.getParameters()).getNumBalancedShards().isPresent()) {
                    spec.args(new Object[]{"--num-balanced-shards", String.valueOf(((EwWorkParameters)this.getParameters()).getNumBalancedShards().get())});
                } else if (((EwWorkParameters)this.getParameters()).getNumUniformShards().isPresent()) {
                    spec.args(new Object[]{"--num-uniform-shards", String.valueOf(((EwWorkParameters)this.getParameters()).getNumUniformShards().get())});
                } else if (((EwWorkParameters)this.getParameters()).getNumShards().isPresent()) {
                    spec.args(new Object[]{"--num-shards", String.valueOf(((EwWorkParameters)this.getParameters()).getNumShards().get())});
                }
                if (((EwWorkParameters)this.getParameters()).getDirectoriesToPull().isPresent() && !(dirsToPull = (List)((EwWorkParameters)this.getParameters()).getDirectoriesToPull().get()).isEmpty()) {
                    spec.args(new Object[]{"--directories-to-pull", String.join((CharSequence)",", dirsToPull)});
                }
                if (((EwWorkParameters)this.getParameters()).getSideEffects().isPresent() && ((Boolean)((EwWorkParameters)this.getParameters()).getSideEffects().get()).booleanValue()) {
                    spec.args(new Object[]{"--side-effects"});
                }
                if (((EwWorkParameters)this.getParameters()).getFileCacheEnabled().isPresent() && !((Boolean)((EwWorkParameters)this.getParameters()).getFileCacheEnabled().get()).booleanValue()) {
                    spec.args(new Object[]{"--no-file-cache"});
                } else if (((EwWorkParameters)this.getParameters()).getFileCacheTtl().isPresent()) {
                    spec.args(new Object[]{"--file-cache-ttl", EwWorkAction.toCliString((Duration)((EwWorkParameters)this.getParameters()).getFileCacheTtl().get())});
                }
                if (((EwWorkParameters)this.getParameters()).getTestCacheEnabled().isPresent() && !((Boolean)((EwWorkParameters)this.getParameters()).getTestCacheEnabled().get()).booleanValue()) {
                    spec.args(new Object[]{"--no-test-cache"});
                }
                if (((EwWorkParameters)this.getParameters()).getNumFlakyTestAttempts().isPresent()) {
                    spec.args(new Object[]{"--num-flaky-test-attempts", ((Integer)((EwWorkParameters)this.getParameters()).getNumFlakyTestAttempts().get()).toString()});
                }
            });
            result.assertNormalExitValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toCliString(Duration duration) {
        return duration.getSeconds() + "s";
    }
}

