/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator.async;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.process.ExecOperations;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wtf.emulator.async.AsyncRunData;
import wtf.emulator.exec.EwCliExecutor;
import wtf.emulator.exec.EwCollectResultsWorkParameters;
import wtf.emulator.exec.EwWorkParameters;

public abstract class EwAsyncExecService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    public static final String NAME = "ewAsyncExecService";
    private static final Logger log = LoggerFactory.getLogger(EwAsyncExecService.class);
    private final ExecutorService threads = Executors.newCachedThreadPool();
    private final AtomicInteger reqsInFlight = new AtomicInteger(0);
    private final List<CompletableFuture<AsyncRunData>> futures = new CopyOnWriteArrayList<CompletableFuture<AsyncRunData>>();

    @Inject
    public abstract ExecOperations getExecOperations();

    public void executeAsync(EwWorkParameters parameters) {
        log.info("Execute asynchronously: {}", parameters.getDisplayName().get());
        EwCliExecutor cliExecutor = new EwCliExecutor(this.getExecOperations());
        this.reqsInFlight.incrementAndGet();
        this.futures.add(CompletableFuture.supplyAsync(() -> {
            try {
                JSONObject obj = cliExecutor.invokeCli(parameters);
                String runUuid = obj.getString("runUuid");
                String runToken = obj.getString("runToken");
                String startTime = obj.getString("startTime");
                String displayName = (String)parameters.getDisplayName().get();
                AsyncRunData asyncRunData = new AsyncRunData(runUuid, runToken, startTime, displayName);
                return asyncRunData;
            }
            finally {
                this.reqsInFlight.decrementAndGet();
            }
        }, this.threads));
    }

    public List<String> drainResults(EwCollectResultsWorkParameters parameters) {
        EwCliExecutor cliExecutor = new EwCliExecutor(this.getExecOperations());
        CompletableFuture[] messageFutures = (CompletableFuture[])this.futures.stream().map(future -> future.thenApply(data -> {
            String folderName = data.getDisplayName().replace(':', '_').replaceAll("[^a-zA-Z0-9_]", "_").replace("^_*", "");
            try {
                return cliExecutor.collectRunResults(parameters, data.getRunUuid(), data.getRunToken(), data.getStartTime(), data.getDisplayName(), folderName);
            }
            catch (Exception exception) {
                return "";
            }
        })).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> drain = CompletableFuture.allOf(messageFutures);
        try {
            drain.get(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return Arrays.stream(messageFutures).map(future -> future.isCompletedExceptionally() ? "" : future.getNow("")).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block8: {
            try {
                this.threads.shutdown();
                if (this.reqsInFlight.get() == 0) {
                    return;
                }
                System.out.println("Waiting up to 5 minutes for " + this.reqsInFlight.get() + " emulator.wtf tests to trigger before exiting");
                try {
                    long start = System.nanoTime();
                    boolean timedOut = this.threads.awaitTermination(5L, TimeUnit.MINUTES);
                    if (!timedOut) {
                        System.out.println("Timed out while waiting for emulator.wtf tests to trigger");
                        break block8;
                    }
                    long elapsed = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start);
                    System.out.println("All emulator.wtf tests triggered after waiting " + elapsed + " seconds");
                }
                catch (InterruptedException e) {
                    System.out.println("Interrupted while waiting for emulator.wtf tests to trigger");
                }
            }
            finally {
                this.futures.clear();
            }
        }
    }
}

