/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import com.android.build.VariantOutput;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskProvider;
import wtf.emulator.EwExecSummaryTask;
import wtf.emulator.EwExecTask;
import wtf.emulator.EwExtension;
import wtf.emulator.EwProperties;
import wtf.emulator.EwVariantFilter;
import wtf.emulator.GradleCompat;
import wtf.emulator.GradleCompatFactory;

public class EwPlugin
implements Plugin<Project> {
    private static final String ROOT_TASK_NAME = "testWithEmulatorWtf";
    private static final String TOOL_CONFIGURATION = "emulatorWtfCli";
    private static final String MAVEN_URL = "https://maven.emulator.wtf/releases/";

    public void apply(final Project target) {
        final EwExtension ext = (EwExtension)target.getExtensions().create("emulatorwtf", EwExtension.class, new Object[0]);
        GradleCompat gradleCompat = GradleCompatFactory.get((Gradle)target.getGradle());
        ext.getBaseOutputDir().convention(target.getLayout().getBuildDirectory().dir("test-results"));
        ext.getRepositoryCheckEnabled().convention((Object)true);
        EwPlugin.configureRepository(target, ext);
        Configuration toolConfig = (Configuration)target.getConfigurations().maybeCreate(TOOL_CONFIGURATION);
        gradleCompat.addProviderDependency(target, TOOL_CONFIGURATION, ext.getVersion().map(version -> "wtf.emulator:ew-cli:" + version));
        Boolean configCache = gradleCompat.isConfigurationCacheEnabled();
        final SetProperty failureCollector = target.getObjects().setProperty(String.class);
        TaskProvider rootTask = target.getTasks().register(ROOT_TASK_NAME, EwExecSummaryTask.class, task -> {
            task.setDescription("Run instrumentation tests of all variants with emulator.wtf");
            task.getPrintingEnabled().set(ext.getIgnoreFailures().map(ignoreFailures -> configCache != false && ignoreFailures != false));
            task.getOutputs().upToDateWhen(it -> false);
        });
        if (!configCache.booleanValue()) {
            target.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

                public void buildFinished(BuildResult result) {
                    List<String> failures;
                    if (((Boolean)ext.getIgnoreFailures().getOrElse((Object)false)).booleanValue() && !(failures = ((Set)failureCollector.get()).stream().filter(it -> it != null && !it.isEmpty()).collect(Collectors.toList())).isEmpty()) {
                        target.getLogger().error("");
                        failures.forEach(arg_0 -> ((Logger)target.getLogger()).error(arg_0));
                    }
                }
            });
        }
        target.getPluginManager().withPlugin("com.android.application", plugin -> {
            AppExtension android = (AppExtension)target.getExtensions().getByType(AppExtension.class);
            android.getApplicationVariants().all(variant -> EwPlugin.configureAppVariant(target, (BaseExtension)android, ext, toolConfig, (TaskProvider<EwExecSummaryTask>)rootTask, (SetProperty<String>)failureCollector, variant));
        });
        target.getPluginManager().withPlugin("com.android.library", plugin -> {
            LibraryExtension android = (LibraryExtension)target.getExtensions().getByType(LibraryExtension.class);
            android.getLibraryVariants().all(variant -> EwPlugin.configureLibraryVariant(target, (BaseExtension)android, ext, toolConfig, (TaskProvider<EwExecSummaryTask>)rootTask, (SetProperty<String>)failureCollector, variant));
        });
        target.getPluginManager().withPlugin("com.android.test", plugin -> {
            TestExtension android = (TestExtension)target.getExtensions().getByType(TestExtension.class);
            android.getApplicationVariants().all(variant -> EwPlugin.configureTestVariant(target, android, ext, toolConfig, (TaskProvider<EwExecSummaryTask>)rootTask, (SetProperty<String>)failureCollector, variant));
        });
    }

    private static void configureRepository(Project target, EwExtension ext) {
        if (!EwProperties.ADD_REPOSITORY.getFlag(target, true)) {
            return;
        }
        Semver gradleVersion = new Semver(target.getGradle().getGradleVersion(), Semver.SemverType.LOOSE);
        if (gradleVersion.isGreaterThanOrEqualTo(new Semver("6.8", Semver.SemverType.LOOSE))) {
            SettingsInternal settings = ((GradleInternal)target.getGradle()).getSettings();
            DependencyResolutionManagement mgmt = settings.getDependencyResolutionManagement();
            boolean registered = mgmt.getRepositories().stream().filter(artifactRepository -> artifactRepository instanceof MavenArtifactRepository).map(artifactRepository -> (MavenArtifactRepository)artifactRepository).anyMatch(EwPlugin::isEmulatorWtfRepo);
            if (registered) {
                return;
            }
            RepositoriesMode mode = (RepositoriesMode)settings.getDependencyResolutionManagement().getRepositoriesMode().getOrNull();
            int settingsRepoCount = settings.getDependencyResolutionManagement().getRepositories().size();
            if ((mode == null || mode == RepositoriesMode.PREFER_PROJECT) && settingsRepoCount == 0) {
                EwPlugin.registerMavenRepo(target);
            } else {
                target.afterEvaluate(evaluated -> {
                    if (Boolean.TRUE.equals(ext.getRepositoryCheckEnabled().getOrNull())) {
                        throw new GradleException("Missing maven.emulator.wtf repository\n\nEither add the following to your dependencyResolutionManagement dependencies block or\nsuppress this message via emulatorWtf { repositoryCheckEnabled.set(false) }:\n\ndependencyResolutionManagement {\n  repositories {\n    maven(url = \"https://maven.emulator.wtf/releases/\") {\n      content { includeGroup(\"wtf.emulator\") }\n    }\n  }\n}\n");
                    }
                });
            }
        } else {
            EwPlugin.registerMavenRepo(target);
        }
    }

    private static boolean isEmulatorWtfRepo(MavenArtifactRepository it) {
        return MAVEN_URL.equals(it.getUrl().toString()) || MAVEN_URL.equals(it.getUrl() + "/");
    }

    private static void registerMavenRepo(Project target) {
        target.getRepositories().maven(repo -> {
            try {
                repo.setUrl((Object)new URI(MAVEN_URL).toURL());
                repo.mavenContent(desc -> desc.includeGroup("wtf.emulator"));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public static void configureAppVariant(Project target, BaseExtension android, EwExtension ext, Configuration toolConfig, TaskProvider<EwExecSummaryTask> rootTask, SetProperty<String> failureCollector, ApplicationVariant variant) {
        TestVariant testVariant = variant.getTestVariant();
        if (testVariant != null) {
            EwPlugin.configureEwTask(target, android, ext, toolConfig, rootTask, failureCollector, variant, task -> {
                BaseVariantOutput appOutput = EwPlugin.getMainOutput(testVariant.getTestedVariant());
                BaseVariantOutput testOutput = EwPlugin.getMainOutput((BaseVariant)testVariant);
                task.dependsOn(new Object[]{testVariant.getPackageApplicationProvider()});
                task.dependsOn(new Object[]{variant.getPackageApplicationProvider()});
                task.getAppApk().set(appOutput.getOutputFile());
                task.getTestApk().set(testOutput.getOutputFile());
            });
        }
    }

    public static void configureLibraryVariant(Project target, BaseExtension android, EwExtension ext, Configuration toolConfig, TaskProvider<EwExecSummaryTask> rootTask, SetProperty<String> failureCollector, LibraryVariant variant) {
        TestVariant testVariant = variant.getTestVariant();
        if (testVariant != null) {
            EwPlugin.configureEwTask(target, android, ext, toolConfig, rootTask, failureCollector, variant, task -> {
                BaseVariantOutput testOutput = EwPlugin.getMainOutput((BaseVariant)testVariant);
                task.dependsOn(new Object[]{testVariant.getPackageApplicationProvider()});
                task.getLibraryTestApk().set(testOutput.getOutputFile());
            });
        }
    }

    public static void configureTestVariant(Project project, TestExtension android, EwExtension ext, Configuration toolConfig, TaskProvider<EwExecSummaryTask> rootTask, SetProperty<String> failureCollector, ApplicationVariant variant) {
        EwPlugin.configureEwTask(project, (BaseExtension)android, ext, toolConfig, rootTask, failureCollector, variant, task -> {
            BaseVariantOutput testOutput = EwPlugin.getMainOutput((BaseVariant)variant);
            task.dependsOn(new Object[]{variant.getPackageApplicationProvider()});
            task.getTestApk().set(testOutput.getOutputFile());
            String targetProjectPath = android.getTargetProjectPath();
            Project target = project.getRootProject().findProject(targetProjectPath);
            if (target == null) {
                throw new IllegalArgumentException("No target project '" + targetProjectPath + "'");
            }
            target.getPluginManager().withPlugin("com.android.application", plugin -> {
                AppExtension targetAndroid = (AppExtension)target.getExtensions().getByType(AppExtension.class);
                targetAndroid.getApplicationVariants().all(targetVariant -> {
                    if (variant.getName().equals(targetVariant.getName())) {
                        BaseVariantOutput appOutput = EwPlugin.getMainOutput((BaseVariant)targetVariant);
                        task.dependsOn(new Object[]{targetVariant.getPackageApplicationProvider()});
                        task.getAppApk().set(appOutput.getOutputFile());
                    }
                });
            });
        });
    }

    private static <T extends TestedVariant & BaseVariant> void configureEwTask(Project target, BaseExtension android, EwExtension ext, Configuration toolConfig, TaskProvider<EwExecSummaryTask> rootTask, SetProperty<String> failureCollector, T variant, Consumer<EwExecTask> additionalConfigure) {
        Action<EwVariantFilter> filter = ext.getFilter();
        if (filter != null) {
            EwVariantFilter filterSpec = new EwVariantFilter(variant);
            filter.execute((Object)filterSpec);
            if (!filterSpec.isEnabled()) {
                return;
            }
        }
        ext.getVariantCount().set((Object)((Integer)ext.getVariantCount().get() + 1));
        Path intermediateFolder = target.getBuildDir().toPath().resolve("intermediates").resolve("emulatorwtf");
        File outputFailureFile = intermediateFolder.resolve("failure_" + ((BaseVariant)variant).getName() + ".txt").toFile();
        Provider outputFailure = target.provider(() -> {
            try {
                if (outputFailureFile.exists()) {
                    return FileUtils.readFileToString((File)outputFailureFile, (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "";
        });
        failureCollector.add(outputFailure);
        rootTask.configure(task -> task.getFailureMessages().add((Object)outputFailureFile));
        String taskName = "test" + EwPlugin.capitalize(((BaseVariant)variant).getName()) + "WithEmulatorWtf";
        TaskProvider execTask = target.getTasks().register(taskName, EwExecTask.class, task -> {
            task.setDescription("Run " + ((BaseVariant)variant).getName() + " instrumentation tests with emulator.wtf");
            task.setGroup("Verification");
            if (ext.getSideEffects().isPresent() && ((Boolean)ext.getSideEffects().get()).booleanValue()) {
                task.getOutputs().upToDateWhen(t -> false);
                task.getSideEffects().set((Object)true);
            }
            task.getClasspath().set((Object)toolConfig);
            task.getToken().set(ext.getToken().orElse(target.provider(() -> System.getenv("EW_API_TOKEN"))));
            if (!((Boolean)task.getAsync().getOrElse((Object)false)).booleanValue()) {
                task.getOutputsDir().set(ext.getBaseOutputDir().map(dir -> dir.dir(((BaseVariant)variant).getName())));
                task.getOutputTypes().set(ext.getOutputs());
            }
            task.getRecordVideo().set(ext.getRecordVideo());
            task.getDevices().set(ext.getDevices().map(devices -> devices.stream().map(config -> {
                HashMap out = new HashMap();
                config.forEach((key, value) -> out.put(key, Objects.toString(value)));
                return out;
            }).collect(Collectors.toList())));
            task.getUseOrchestrator().set(ext.getUseOrchestrator().orElse(target.provider(() -> android.getTestOptions().getExecution().equalsIgnoreCase("ANDROIDX_TEST_ORCHESTRATOR"))));
            task.getClearPackageData().set(ext.getClearPackageData());
            task.getWithCoverage().set(ext.getWithCoverage().orElse(target.provider(() -> ((BaseVariant)variant).getBuildType().isTestCoverageEnabled())));
            task.getAdditionalApks().set(ext.getAdditionalApks());
            task.getEnvironmentVariables().set(ext.getEnvironmentVariables().map(entries -> {
                HashMap out = new HashMap(((BaseVariant)variant).getMergedFlavor().getTestInstrumentationRunnerArguments());
                entries.forEach((key, value) -> out.put(key, Objects.toString(value)));
                return out;
            }));
            task.getNumUniformShards().set(ext.getNumUniformShards());
            task.getNumShards().set(ext.getNumShards());
            task.getNumBalancedShards().set(ext.getNumBalancedShards());
            task.getDirectoriesToPull().set(ext.getDirectoriesToPull());
            task.getTestTimeout().set(ext.getTimeout());
            task.getFileCacheEnabled().set(ext.getFileCacheEnabled());
            task.getFileCacheTtl().set(ext.getFileCacheTtl());
            task.getTestCacheEnabled().set(ext.getTestCacheEnabled());
            task.getNumFlakyTestAttempts().set(ext.getNumFlakyTestAttempts());
            task.getScmUrl().set(ext.getScmUrl());
            task.getScmCommitHash().set(ext.getScmCommitHash());
            task.getPrintOutput().set(ext.getPrintOutput());
            task.getDisplayName().set(ext.getDisplayName().orElse(ext.getVariantCount().map(count -> {
                String name = task.getProject().getPath();
                if (name.equals(":")) {
                    name = task.getProject().getName();
                }
                if (count < 2) {
                    return name;
                }
                return name + ":" + ((BaseVariant)variant).getName();
            })));
            task.getWorkingDir().set(target.getRootProject().getRootDir());
            task.getOutputFailureFile().set(outputFailureFile);
            task.getIgnoreFailures().set(ext.getIgnoreFailures());
            task.getAsync().set(ext.getAsync());
            additionalConfigure.accept((EwExecTask)((Object)task));
        });
        rootTask.configure(task -> task.dependsOn(new Object[]{execTask}));
    }

    private static BaseVariantOutput getMainOutput(BaseVariant variant) {
        return variant.getOutputs().stream().filter(it -> it.getOutputType().equals(VariantOutput.MAIN)).findFirst().orElse((BaseVariantOutput)variant.getOutputs().stream().findFirst().orElseThrow(() -> new IllegalStateException("Test variant has no outputs!")));
    }

    private static String capitalize(String str) {
        if (str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toUpperCase(Locale.US) + str.substring(1);
    }
}

