/*
 * Decompiled with CFR 0.152.
 */
package wtf.emulator;

import com.android.build.VariantOutput;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import com.vdurmont.semver4j.Semver;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.initialization.resolve.RepositoriesMode;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import wtf.emulator.EwExecTask;
import wtf.emulator.EwExtension;

public class EwPlugin
implements Plugin<Project> {
    private static final String TOOL_CONFIGURATION = "emulatorWtfCli";
    private static final String MAVEN_URL = "https://maven.emulator.wtf/releases/";

    public void apply(Project target) {
        EwExtension ext = (EwExtension)target.getExtensions().create("emulatorwtf", EwExtension.class, new Object[0]);
        ext.getBaseOutputDir().convention(target.getLayout().getBuildDirectory().dir("test-results"));
        ext.getRepositoryCheckEnabled().convention((Object)true);
        EwPlugin.configureRepository(target, ext);
        Configuration toolConfig = (Configuration)target.getConfigurations().maybeCreate(TOOL_CONFIGURATION);
        target.getDependencies().add(TOOL_CONFIGURATION, (Object)ext.getVersion().map(version -> "wtf.emulator:ew-cli:" + version));
        target.getPluginManager().withPlugin("com.android.application", plugin -> {
            AppExtension android = (AppExtension)target.getExtensions().getByType(AppExtension.class);
            android.getApplicationVariants().all(variant -> this.configureVariant(target, (BaseExtension)android, ext, toolConfig, variant));
        });
        target.getPluginManager().withPlugin("com.android.library", plugin -> {
            LibraryExtension android = (LibraryExtension)target.getExtensions().getByType(LibraryExtension.class);
            android.getLibraryVariants().all(variant -> this.configureVariant(target, (BaseExtension)android, ext, toolConfig, variant));
        });
    }

    private static void configureRepository(Project target, EwExtension ext) {
        Semver gradleVersion = new Semver(target.getGradle().getGradleVersion(), Semver.SemverType.LOOSE);
        if (gradleVersion.isGreaterThanOrEqualTo(new Semver("6.8", Semver.SemverType.LOOSE))) {
            SettingsInternal settings = ((GradleInternal)target.getGradle()).getSettings();
            DependencyResolutionManagement mgmt = settings.getDependencyResolutionManagement();
            boolean registered = mgmt.getRepositories().stream().filter(artifactRepository -> artifactRepository instanceof MavenArtifactRepository).map(artifactRepository -> (MavenArtifactRepository)artifactRepository).anyMatch(EwPlugin::isEmulatorWtfRepo);
            if (registered) {
                return;
            }
            RepositoriesMode mode = (RepositoriesMode)settings.getDependencyResolutionManagement().getRepositoriesMode().getOrNull();
            if (mode == null || RepositoriesMode.PREFER_PROJECT.equals((Object)mode)) {
                EwPlugin.registerMavenRepo(target);
            } else {
                target.afterEvaluate(evaluated -> {
                    if (Boolean.TRUE.equals(ext.getRepositoryCheckEnabled().getOrNull())) {
                        throw new GradleException("Missing maven.emulator.wtf repository\n\nEither add the following to your dependencyResolutionManagement dependencies block or\nsuppress this message via emulatorWtf { repositoryCheckEnabled.set(false) }:\n\ndependencyResolutionManagement {\n  repositories {\n    maven(url = \"https://maven.emulator.wtf/releases/\") {\n      content { includeGroup(\"wtf.emulator\") }\n    }\n  }\n}\n");
                    }
                });
            }
        } else {
            EwPlugin.registerMavenRepo(target);
        }
    }

    private static boolean isEmulatorWtfRepo(MavenArtifactRepository it) {
        return MAVEN_URL.equals(it.getUrl().toString()) || MAVEN_URL.equals(it.getUrl() + "/");
    }

    private static void registerMavenRepo(Project target) {
        target.getRepositories().maven(repo -> {
            try {
                repo.setUrl((Object)new URI(MAVEN_URL).toURL());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public <T extends TestedVariant & BaseVariant> void configureVariant(Project target, BaseExtension android, EwExtension ext, Configuration toolConfig, T variant) {
        String taskName = "test" + EwPlugin.capitalize(((BaseVariant)variant).getName()) + "WithEmulatorWtf";
        TestVariant testVariant = variant.getTestVariant();
        if (testVariant != null) {
            target.getTasks().register(taskName, EwExecTask.class, task -> {
                task.setDescription("Run " + ((BaseVariant)variant).getName() + " instrumentation tests with emulator.wtf");
                task.setGroup("Verification");
                task.getClasspath().set((Object)toolConfig);
                task.getToken().set(ext.getToken().orElse(target.provider(() -> System.getenv("EW_API_TOKEN"))));
                task.dependsOn(new Object[]{testVariant.getPackageApplicationProvider()});
                BaseVariantOutput appOutput = EwPlugin.getMainOutput(testVariant.getTestedVariant());
                BaseVariantOutput testOutput = EwPlugin.getMainOutput((BaseVariant)testVariant);
                if (appOutput instanceof ApkVariantOutput) {
                    task.dependsOn(new Object[]{((ApkVariant)variant).getPackageApplicationProvider()});
                    task.getAppApk().set(appOutput.getOutputFile());
                    task.getTestApk().set(testOutput.getOutputFile());
                } else {
                    task.getLibraryTestApk().set(testOutput.getOutputFile());
                }
                task.getOutputsDir().set(ext.getBaseOutputDir().map(dir -> dir.dir(((BaseVariant)variant).getName())));
                task.getDevices().set(ext.getDevices().map(devices -> devices.stream().map(config -> {
                    HashMap out = new HashMap();
                    config.forEach((key, value) -> out.put(key, Objects.toString(value)));
                    return out;
                }).collect(Collectors.toList())));
                task.getUseOrchestrator().set(ext.getUseOrchestrator().orElse(target.provider(() -> android.getTestOptions().getExecution().equalsIgnoreCase("ANDROIDX_TEST_ORCHESTRATOR"))));
                task.getClearPackageData().set(ext.getClearPackageData());
                task.getWithCoverage().set(ext.getWithCoverage().orElse(target.provider(() -> ((BaseVariant)variant).getBuildType().isTestCoverageEnabled())));
                task.getAdditionalApks().set(ext.getAdditionalApks());
                task.getEnvironmentVariables().set(ext.getEnvironmentVariables().map(entries -> {
                    HashMap out = new HashMap(((BaseVariant)variant).getMergedFlavor().getTestInstrumentationRunnerArguments());
                    entries.forEach((key, value) -> out.put(key, Objects.toString(value)));
                    return out;
                }));
                task.getNumUniformShards().set(ext.getNumUniformShards());
                task.getNumShards().set(ext.getNumShards());
                task.getDirectoriesToPull().set(ext.getDirectoriesToPull());
            });
        }
    }

    private static BaseVariantOutput getMainOutput(BaseVariant variant) {
        return variant.getOutputs().stream().filter(it -> it.getOutputType().equals(VariantOutput.MAIN)).findFirst().orElse((BaseVariantOutput)variant.getOutputs().stream().findFirst().orElseThrow(() -> new IllegalStateException("Test variant has no outputs!")));
    }

    private static String capitalize(String str) {
        if (str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toUpperCase(Locale.US) + str.substring(1);
    }
}

