/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.encode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.VideoAttributes;

public class EncodingAttributes
implements Serializable {
    private static final long serialVersionUID = 2473587816471032706L;
    private String inputFormat = null;
    private String outputFormat = null;
    private Float offset = null;
    private Float duration = null;
    private AudioAttributes audioAttributes = null;
    private VideoAttributes videoAttributes = null;
    private boolean mapMetaData = false;
    private Integer filterThreads;
    private Integer decodingThreads = null;
    private Integer encodingThreads = null;
    private boolean loop = false;
    private Integer safe = null;
    private final HashMap<String, String> extraContext = new HashMap();

    public Map<String, String> getExtraContext() {
        return this.extraContext;
    }

    public EncodingAttributes setExtraContext(Map<String, String> context) {
        this.extraContext.putAll(context);
        return this;
    }

    public Optional<String> getInputFormat() {
        return Optional.ofNullable(this.inputFormat);
    }

    public EncodingAttributes setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
        return this;
    }

    public Optional<String> getOutputFormat() {
        return Optional.ofNullable(this.outputFormat);
    }

    public EncodingAttributes setOutputFormat(String format) {
        this.outputFormat = format;
        return this;
    }

    public Optional<Float> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public EncodingAttributes setOffset(Float offset) {
        this.offset = offset;
        return this;
    }

    public Optional<Float> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    public EncodingAttributes setDuration(Float duration) {
        this.duration = duration;
        return this;
    }

    public boolean getLoop() {
        return this.loop;
    }

    public EncodingAttributes setLoop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public Optional<Integer> getSafe() {
        return Optional.ofNullable(this.safe);
    }

    public EncodingAttributes setSafe(Integer safe) {
        this.safe = safe;
        return this;
    }

    public Optional<AudioAttributes> getAudioAttributes() {
        return Optional.ofNullable(this.audioAttributes);
    }

    public EncodingAttributes setAudioAttributes(AudioAttributes audioAttributes) {
        this.audioAttributes = audioAttributes;
        return this;
    }

    public Optional<VideoAttributes> getVideoAttributes() {
        return Optional.ofNullable(this.videoAttributes);
    }

    public EncodingAttributes setVideoAttributes(VideoAttributes videoAttributes) {
        this.videoAttributes = videoAttributes;
        return this;
    }

    public String toString() {
        return this.getClass().getName() + "(format=" + this.outputFormat + ", offset=" + this.offset + ", duration=" + this.duration + ",loop=" + this.loop + ", audioAttributes=" + this.audioAttributes + ", videoAttributes=" + this.videoAttributes + ")";
    }

    public boolean isMapMetaData() {
        return this.mapMetaData;
    }

    public EncodingAttributes setMapMetaData(boolean mapMetaData) {
        this.mapMetaData = mapMetaData;
        return this;
    }

    public Optional<Integer> getFilterThreads() {
        return Optional.ofNullable(this.filterThreads);
    }

    public EncodingAttributes setFilterThreads(int filterThreads) {
        this.filterThreads = filterThreads;
        return this;
    }

    public Optional<Integer> getDecodingThreads() {
        return Optional.ofNullable(this.decodingThreads);
    }

    public EncodingAttributes setDecodingThreads(int decodingThreads) {
        this.decodingThreads = decodingThreads;
        return this;
    }

    public Optional<Integer> getEncodingThreads() {
        return Optional.ofNullable(this.encodingThreads);
    }

    public EncodingAttributes setEncodingThreads(Integer encodingThreads) {
        this.encodingThreads = encodingThreads;
        return this;
    }

    public void validate() {
        if (this.audioAttributes == null && this.videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
    }
}

