/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.FFMPEGLocator;

public class DefaultFFMPEGLocator
extends FFMPEGLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFFMPEGLocator.class);
    private static final String MY_EXE_VERSION = "2.7.2";
    private final String path;

    public DefaultFFMPEGLocator() {
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("windows");
        boolean isMac = os.contains("mac");
        LOG.debug("Os name is <{}> isWindows: {} isMac: {}", new Object[]{os, isWindows, isMac});
        File dirFolder = new File(System.getProperty("java.io.tmpdir"), "jave/");
        if (!dirFolder.exists()) {
            LOG.debug("Creating jave temp folder to place executables in <{}>", (Object)dirFolder.getAbsolutePath());
            dirFolder.mkdirs();
        } else {
            LOG.debug("Jave temp folder exists in <{}>", (Object)dirFolder.getAbsolutePath());
        }
        String suffix = isWindows ? ".exe" : (isMac ? "-osx" : "");
        String arch = System.getProperty("os.arch");
        File ffmpegFile = new File(dirFolder, "ffmpeg-" + arch + "-" + MY_EXE_VERSION + suffix);
        LOG.debug("Executable path: {}", (Object)ffmpegFile.getAbsolutePath());
        if (ffmpegFile.exists()) {
            LOG.debug("Executable exists in <{}>", (Object)ffmpegFile.getAbsolutePath());
        } else {
            LOG.debug("Need to copy executable to <{}>", (Object)ffmpegFile.getAbsolutePath());
            this.copyFile("ffmpeg-" + arch + suffix, ffmpegFile);
        }
        if (!isWindows) {
            try {
                Runtime.getRuntime().exec(new String[]{"/bin/chmod", "755", ffmpegFile.getAbsolutePath()});
            }
            catch (IOException e) {
                LOG.error("Error setting executable via chmod", (Throwable)e);
            }
        }
        this.path = ffmpegFile.getAbsolutePath();
        LOG.debug("ffmpeg executable found: {}", (Object)this.path);
    }

    @Override
    public String getFFMPEGExecutablePath() {
        return this.path;
    }

    private void copyFile(String path, File dest) {
        String resourceName = "nativebin/" + path;
        try {
            LOG.debug("Copy from resource <{}> to target <{}>", (Object)resourceName, (Object)dest.getAbsolutePath());
            InputStream is = this.getClass().getResourceAsStream(resourceName);
            if (is == null) {
                resourceName = "ws/schild/jave/nativebin/" + path;
                LOG.debug("Alternative copy from SystemResourceAsStream <{}> to target <{}>", (Object)resourceName, (Object)dest.getAbsolutePath());
                is = ClassLoader.getSystemResourceAsStream(resourceName);
            }
            if (is != null) {
                if (this.copy(is, dest.getAbsolutePath())) {
                    if (dest.exists()) {
                        LOG.debug("Target <{}> exists", (Object)dest.getAbsolutePath());
                    } else {
                        LOG.error("Target <{}> does not exist", (Object)dest.getAbsolutePath());
                    }
                } else {
                    LOG.error("Copy resource to target <{}> failed", (Object)dest.getAbsolutePath());
                }
            } else {
                LOG.error("Could not find ffmpeg platform executable in resources for <{}>", (Object)resourceName);
            }
        }
        catch (NullPointerException ex) {
            LOG.error("Could not find ffmpeg executable for {} is the correct platform jar included?", (Object)resourceName);
            throw ex;
        }
    }

    private boolean copy(InputStream source, String destination) {
        boolean success = true;
        try {
            Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            LOG.error("Cannot write file " + destination, (Throwable)ex);
            success = false;
        }
        return success;
    }
}

