/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import ws.schild.jave.FFMPEGExecutor;
import ws.schild.jave.FFMPEGLocator;

public class DefaultFFMPEGLocator
extends FFMPEGLocator {
    private static final Log LOG = LogFactory.getLog(FFMPEGExecutor.class);
    private static final String MY_EXE_VERSION = "2.4.1";
    private final String path;

    public DefaultFFMPEGLocator() {
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("windows");
        boolean isMac = os.contains("mac");
        File dirFolder = new File(System.getProperty("java.io.tmpdir"), "jave/");
        if (!dirFolder.exists()) {
            dirFolder.mkdirs();
        }
        String suffix = isWindows ? ".exe" : (isMac ? "-osx" : "");
        String arch = System.getProperty("os.arch");
        File ffmpegFile = new File(dirFolder, "ffmpeg-" + arch + "-" + MY_EXE_VERSION + suffix);
        LOG.debug((Object)("Executable path: " + ffmpegFile.getAbsolutePath()));
        if (!ffmpegFile.exists()) {
            this.copyFile("ffmpeg-" + arch + suffix, ffmpegFile);
        }
        if (!isWindows) {
            try {
                Runtime.getRuntime().exec(new String[]{"/bin/chmod", "755", ffmpegFile.getAbsolutePath()});
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        this.path = ffmpegFile.getAbsolutePath();
        LOG.debug((Object)("ffmpeg executable found: " + this.path));
    }

    @Override
    protected String getFFMPEGExecutablePath() {
        return this.path;
    }

    private void copyFile(String path, File dest) {
        this.copy(this.getClass().getResourceAsStream("native/" + path), dest.getAbsolutePath());
    }

    private boolean copy(InputStream source, String destination) {
        boolean success = true;
        try {
            Files.copy(source, Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            LOG.warn((Object)("Cannot write file " + destination), (Throwable)ex);
            success = false;
        }
        return success;
    }
}

