/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMSourcedElementImpl
extends OMElementImpl {
    private final OMDataSource dataSource;
    private OMNamespace definedNamespace;
    private boolean isParserSet;
    private static Log log = LogFactory.getLog((Class)OMSourcedElementImpl.class);

    public OMSourcedElementImpl(String localName, OMNamespace ns, OMFactory factory, OMDataSource source) {
        super(localName, null, factory);
        this.dataSource = source;
        this.definedNamespace = ns;
    }

    public OMSourcedElementImpl(QName qName, OMFactory factory, OMDataSource source) {
        this(qName.getLocalPart(), factory.createOMNamespace(qName.getNamespaceURI(), qName.getPrefix()), factory, source);
    }

    private String getPrintableName() {
        String uri = this.getNamespace().getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return this.getLocalName();
        }
        return "{" + uri + '}' + this.getLocalName();
    }

    private XMLStreamReader getDirectReader() {
        try {
            return this.dataSource.getReader();
        }
        catch (XMLStreamException e) {
            log.error((Object)("Could not get parser from data source for element " + this.getPrintableName()), (Throwable)e);
            throw new RuntimeException("Error obtaining parser from data source:" + e.getMessage());
        }
    }

    private void forceExpand() {
        if (!this.isParserSet) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("forceExpand: expanding element " + this.getPrintableName()));
            }
            XMLStreamReader reader = this.getDirectReader();
            try {
                if (reader.getEventType() != 1) {
                    while (reader.next() != 1) {
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)("forceExpand: error parsing data soruce document for element " + this.getLocalName()), (Throwable)e);
                throw new RuntimeException("Error parsing data source document:" + e.getMessage());
            }
            if (!reader.getLocalName().equals(this.getLocalName())) {
                log.error((Object)("forceExpand: expected element name " + this.getLocalName() + ", found " + reader.getLocalName()));
                throw new RuntimeException("Element name from data source is " + reader.getLocalName() + ", not the expected " + this.getLocalName());
            }
            if (!reader.getNamespaceURI().equals(this.getNamespace().getNamespaceURI())) {
                String uri = this.getNamespace().getNamespaceURI();
                log.error((Object)("forceExpand: expected element namespace " + this.getLocalName() + ", found " + uri));
                throw new RuntimeException("Element namespace from data source is " + reader.getNamespaceURI() + ", not the expected " + uri);
            }
            this.isParserSet = true;
            super.setBuilder(new StAXOMBuilder(this.getOMFactory(), reader, this));
            this.setComplete(false);
        }
    }

    public boolean isExpanded() {
        return this.isParserSet;
    }

    public Iterator getChildElements() {
        this.forceExpand();
        return super.getChildElements();
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.declareNamespace(uri, prefix);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        this.forceExpand();
        return super.declareDefaultNamespace(uri);
    }

    public OMNamespace getDefaultNamespace() {
        this.forceExpand();
        return super.getDefaultNamespace();
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        this.forceExpand();
        return super.declareNamespace(namespace);
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        this.forceExpand();
        return super.findNamespace(uri, prefix);
    }

    public OMNamespace findNamespaceURI(String prefix) {
        this.forceExpand();
        return super.findNamespaceURI(prefix);
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        this.forceExpand();
        return super.getAllDeclaredNamespaces();
    }

    public Iterator getAllAttributes() {
        this.forceExpand();
        return super.getAllAttributes();
    }

    public OMAttribute getAttribute(QName qname) {
        this.forceExpand();
        return super.getAttribute(qname);
    }

    public String getAttributeValue(QName qname) {
        this.forceExpand();
        return super.getAttributeValue(qname);
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        this.forceExpand();
        return super.addAttribute(attr);
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace namespace) {
        this.forceExpand();
        return super.addAttribute(attributeName, value, namespace);
    }

    public void removeAttribute(OMAttribute attr) {
        this.forceExpand();
        super.removeAttribute(attr);
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        throw new UnsupportedOperationException("Builder cannot be set for element backed by data source");
    }

    public OMXMLParserWrapper getBuilder() {
        this.forceExpand();
        return super.getBuilder();
    }

    public void setFirstChild(OMNode node) {
        this.forceExpand();
        super.setFirstChild(node);
    }

    public OMElement getFirstElement() {
        this.forceExpand();
        return super.getFirstElement();
    }

    public XMLStreamReader getXMLStreamReader() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting XMLStreamReader for " + this.getPrintableName()));
        }
        if (this.isParserSet) {
            return super.getXMLStreamReader();
        }
        return this.getDirectReader();
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting XMLStreamReader without caching for " + this.getPrintableName()));
        }
        if (this.isParserSet) {
            return super.getXMLStreamReaderWithoutCaching();
        }
        return this.getDirectReader();
    }

    public void setText(String text) {
        this.forceExpand();
        super.setText(text);
    }

    public void setText(QName text) {
        this.forceExpand();
        super.setText(text);
    }

    public String getText() {
        this.forceExpand();
        return super.getText();
    }

    public QName getTextAsQName() {
        this.forceExpand();
        return super.getTextAsQName();
    }

    public String getLocalName() {
        return super.getLocalName();
    }

    public void setLocalName(String localName) {
        super.setLocalName(localName);
    }

    public OMNamespace getNamespace() throws OMException {
        return this.definedNamespace;
    }

    public void setNamespace(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespace(namespace);
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.forceExpand();
        super.setNamespaceWithNoFindInCurrentScope(namespace);
    }

    public QName getQName() {
        if (this.isParserSet) {
            return super.getQName();
        }
        if (this.definedNamespace != null) {
            return new QName(this.definedNamespace.getNamespaceURI(), this.getLocalName());
        }
        return new QName(this.getLocalName());
    }

    public String toStringWithConsume() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        this.dataSource.serialize(writer, null);
        return writer.toString();
    }

    public QName resolveQName(String qname) {
        this.forceExpand();
        return super.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        this.forceExpand();
        return super.cloneOMElement();
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public void discard() throws OMException {
        this.setComplete(true);
        super.detach();
    }

    public int getType() {
        return super.getType();
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerializeAndConsume(writer);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        this.internalSerializeAndConsume(writer);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to XMLStreamWriter"));
        }
        this.dataSource.serialize(writer);
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerializeAndConsume(xmlWriter);
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(output);
    }

    public void serialize(Writer writer) throws XMLStreamException {
        this.serializeAndConsume(writer);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        this.serializeAndConsume(output, format);
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        this.serializeAndConsume(writer, format);
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.internalSerializeAndConsume(xmlWriter);
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to output stream"));
        }
        this.dataSource.serialize(output, null);
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize " + this.getPrintableName() + " to writer"));
        }
        this.dataSource.serialize(writer, null);
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize formatted " + this.getPrintableName() + " to output stream"));
        }
        this.dataSource.serialize(output, format);
    }

    public void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize formatted " + this.getPrintableName() + " to writer"));
        }
        this.dataSource.serialize(writer, format);
    }

    public void addChild(OMNode omNode) {
        this.forceExpand();
        super.addChild(omNode);
    }

    public Iterator getChildrenWithName(QName elementQName) {
        this.forceExpand();
        return super.getChildrenWithName(elementQName);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        this.forceExpand();
        return super.getFirstChildWithName(elementQName);
    }

    public Iterator getChildren() {
        this.forceExpand();
        return super.getChildren();
    }

    public OMNode getFirstOMChild() {
        this.forceExpand();
        return super.getFirstOMChild();
    }

    public void buildNext() {
        this.forceExpand();
        super.buildNext();
    }

    public OMNode detach() throws OMException {
        boolean complete = this.isComplete();
        this.setComplete(true);
        OMNode result = super.detach();
        this.setComplete(complete);
        return result;
    }

    public OMNode getNextOMSibling() throws OMException {
        return super.getNextOMSibling();
    }

    public String getTrimmedText() {
        this.forceExpand();
        return super.getTrimmedText();
    }

    OMNamespace handleNamespace(QName qname) {
        this.forceExpand();
        return super.handleNamespace(qname);
    }

    public boolean isComplete() {
        if (this.isParserSet) {
            return super.isComplete();
        }
        return true;
    }

    public String toString() {
        this.forceExpand();
        return super.toString();
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    public void build() throws OMException {
        super.build();
    }

    protected void notifyChildComplete() {
        super.notifyChildComplete();
    }
}

