/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.OMNamespaceImpl;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.OMStAXWrapper;
import org.apache.axiom.om.impl.traverse.OMChildElementIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;

public class OMElementImpl
extends OMNodeImpl
implements OMElement,
OMConstants,
OMContainerEx {
    protected OMNamespace ns;
    protected String localName;
    protected OMNode firstChild;
    protected HashMap namespaces = null;
    protected HashMap attributes = null;
    protected int noPrefixNamespaceCounter = 0;
    protected OMNode lastChild;
    private int lineNumber;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public OMElementImpl(String localName, OMNamespace ns, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(parent, factory);
        this.localName = localName;
        if (ns != null) {
            this.setNamespace(ns);
        }
        this.builder = builder;
        this.firstChild = null;
    }

    public OMElementImpl(String localName, OMNamespace ns, OMFactory factory) {
        this(localName, ns, null, factory);
    }

    public OMElementImpl(String localName, OMNamespace ns, OMContainer parent, OMFactory factory) {
        super(parent, factory);
        if (localName == null || localName.trim().length() == 0) {
            throw new OMException("localname can not be null or empty");
        }
        this.localName = localName;
        this.done = true;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMElementImpl(QName qname, OMContainer parent, OMFactory factory) throws OMException {
        this(qname.getLocalPart(), null, parent, factory);
        this.ns = this.handleNamespace(qname);
    }

    OMNamespace handleNamespace(QName qname) {
        OMNamespace ns = null;
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0) {
            ns = this.findNamespace(qname.getNamespaceURI(), qname.getPrefix());
            if (ns == null) {
                String prefix = qname.getPrefix();
                if ("".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                ns = this.declareNamespace(namespaceURI, prefix);
            }
            if (ns != null) {
                this.ns = ns;
            }
        }
        return ns;
    }

    private OMNamespace handleNamespace(OMNamespace ns) {
        OMNamespace namespace = this.findNamespace(ns.getName(), ns.getPrefix());
        if (namespace == null) {
            namespace = this.declareNamespace(ns);
        }
        return namespace;
    }

    public void addChild(OMNode child) {
        this.addChild((OMNodeImpl)child);
    }

    public Iterator getChildrenWithName(QName elementQName) {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    private void addChild(OMNodeImpl child) {
        child.setParent((OMContainer)this);
        if (this.firstChild == null) {
            this.firstChild = child;
            child.previousSibling = null;
        } else {
            child.previousSibling = (OMNodeImpl)this.lastChild;
            ((OMNodeImpl)this.lastChild).nextSibling = child;
        }
        child.nextSibling = null;
        this.lastChild = child;
    }

    public OMNode getNextOMSibling() throws OMException {
        while (!this.done) {
            int token = this.builder.next();
            if (token != 8) continue;
            throw new OMException();
        }
        return super.getNextOMSibling();
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        OMNamespaceImpl ns = new OMNamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        if (uri == null || "".equals(uri)) {
            return null;
        }
        OMNamespaceImpl namespace = new OMNamespaceImpl(uri, "");
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put("", namespace);
        return namespace;
    }

    public OMNamespace getDefaultNamespace() {
        OMNamespace defaultNS;
        if (this.namespaces != null && (defaultNS = (OMNamespace)this.namespaces.get("")) != null) {
            return defaultNS;
        }
        if (this.parent instanceof OMElementImpl) {
            return ((OMElementImpl)this.parent).getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        String prefix;
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        if ((prefix = namespace.getPrefix()) == null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
            namespace = new OMNamespaceImpl(namespace.getName(), prefix);
        }
        this.namespaces.put(prefix, namespace);
        return namespace;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        if (this.parent != null && this.parent instanceof OMElement) {
            namespace = ((OMElementImpl)this.parent).findNamespace(uri, prefix);
        }
        return namespace;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        OMNamespace ns;
        OMNamespace oMNamespace = ns = this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        if (ns == null && this.parent instanceof OMElement) {
            ns = ((OMElement)this.parent).findNamespaceURI(prefix);
        }
        return ns;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            return null;
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return new OMNamespaceImpl(uri, prefix);
        }
        if (this.namespaces == null) {
            return null;
        }
        if (prefix == null || "".equals(prefix)) {
            OMNamespace defaultNamespace = this.getDefaultNamespace();
            if (defaultNamespace != null && uri.equals(defaultNamespace.getName())) {
                return defaultNamespace;
            }
            Iterator namespaceListIterator = this.namespaces.values().iterator();
            while (namespaceListIterator.hasNext()) {
                OMNamespace omNamespace = (OMNamespace)namespaceListIterator.next();
                String nsUri = omNamespace.getName();
                if (nsUri == null || !nsUri.equals(uri)) continue;
                return omNamespace;
            }
        } else {
            OMNamespace namespace = (OMNamespace)this.namespaces.get(prefix);
            if (namespace != null && uri.equalsIgnoreCase(namespace.getName())) {
                return namespace;
            }
        }
        return null;
    }

    public Iterator getAllDeclaredNamespaces() {
        if (this.namespaces == null) {
            return EMPTY_ITERATOR;
        }
        return this.namespaces.values().iterator();
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.attributes.values().iterator();
    }

    public OMAttribute getAttribute(QName qname) {
        return this.attributes == null ? null : (OMAttribute)this.attributes.get(qname);
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        OMNamespace namespace;
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        if ((namespace = attr.getNamespace()) != null && this.findNamespace(namespace.getName(), namespace.getPrefix()) == null) {
            this.declareNamespace(namespace.getName(), namespace.getPrefix());
        }
        this.attributes.put(attr.getQName(), attr);
        return attr;
    }

    public void removeAttribute(OMAttribute attr) {
        if (this.attributes != null) {
            this.attributes.remove(attr.getQName());
        }
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace ns) {
        OMNamespace namespace;
        if (ns != null && (namespace = this.findNamespace(ns.getName(), ns.getPrefix())) == null) {
            throw new OMException("Given OMNamespace(" + ns.getName() + " " + ns.getPrefix() + ") for " + "this attribute is not declared in the scope of this element. First declare the namespace" + " and then use it with the attribute");
        }
        return this.addAttribute(new OMAttributeImpl(attributeName, ns, value, this.factory));
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public void buildNext() {
        this.builder.next();
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    public void setFirstChild(OMNode firstChild) {
        if (firstChild != null) {
            ((OMNodeEx)firstChild).setParent((OMContainer)this);
        }
        this.firstChild = firstChild;
    }

    public OMNode detach() throws OMException {
        if (!this.done) {
            this.build();
        }
        super.detach();
        return this;
    }

    public boolean isComplete() {
        return this.done;
    }

    public int getType() {
        return 1;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    private XMLStreamReader getXMLStreamReader(boolean cache) {
        if (this.builder == null && !cache) {
            throw new UnsupportedOperationException("This element was not created in a manner to be switched");
        }
        if (this.builder != null && this.builder.isCompleted() && !cache) {
            throw new UnsupportedOperationException("The parser is already consumed!");
        }
        return new OMStAXWrapper(this.builder, this, cache);
    }

    public void setText(String text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMElement)this, text);
    }

    public void setText(QName text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMElement)this, text);
    }

    public String getText() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            if (child.getType() != 4 || (textNode = (OMText)child).getText() == null || "".equals(textNode.getText())) continue;
            childText = childText + textNode.getText();
        }
        return childText;
    }

    public QName getTextAsQName() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            if (child.getType() != 4 || (textNode = (OMText)child).getText() == null || "".equals(textNode.getText())) continue;
            String namespaceURI = textNode.getTextAsQName().getNamespaceURI();
            if (namespaceURI != null && !"".equals(namespaceURI)) {
                return textNode.getTextAsQName();
            }
            childText = childText + textNode.getText();
        }
        return new QName(childText);
    }

    public String getTrimmedText() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            if (child.getType() != 4 || (textNode = (OMText)child).getText() == null || "".equals(textNode.getText().trim())) continue;
            childText = childText + textNode.getText().trim();
        }
        return childText;
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache) {
            OMSerializerUtil.serializeStartpart((OMElement)this, (XMLStreamWriter)writer);
            Iterator children = this.getChildren();
            while (children.hasNext()) {
                ((OMNodeEx)children.next()).internalSerialize(writer);
            }
            OMSerializerUtil.serializeEndpart((XMLStreamWriter)writer);
        } else if (this.done) {
            OMSerializerUtil.serializeStartpart((OMElement)this, (XMLStreamWriter)writer);
            OMNodeImpl child = (OMNodeImpl)this.firstChild;
            while (child != null && (!(child instanceof OMElement) || child.isComplete())) {
                child.internalSerializeAndConsume(writer);
                child = child.nextSibling;
            }
            if (child != null) {
                OMElement element = (OMElement)child;
                element.getBuilder().setCache(false);
                OMSerializerUtil.serializeByPullStream((OMElement)element, (XMLStreamWriter)writer, (boolean)cache);
            }
            OMSerializerUtil.serializeEndpart((XMLStreamWriter)writer);
        } else {
            OMSerializerUtil.serializeByPullStream((OMElement)this, (XMLStreamWriter)writer, (boolean)cache);
        }
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    public OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public OMNamespace getNamespace() throws OMException {
        return this.ns != null ? this.ns : this.getDefaultNamespace();
    }

    public void setNamespace(OMNamespace namespace) {
        OMNamespace nsObject = null;
        if (namespace != null) {
            nsObject = this.handleNamespace(namespace);
        }
        this.ns = nsObject;
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.ns = namespace;
    }

    public QName getQName() {
        QName qName = this.ns != null ? (this.ns.getPrefix() != null ? new QName(this.ns.getName(), this.localName, this.ns.getPrefix()) : new QName(this.ns.getName(), this.localName)) : new QName(this.localName);
        return qName;
    }

    public String toStringWithConsume() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serializeAndConsume(baos);
        return new String(baos.toByteArray());
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(baos);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e);
        }
        return new String(baos.toByteArray());
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        } else {
            this.builder.discard((OMElement)this);
        }
    }

    public QName resolveQName(String qname) {
        ElementHelper helper = new ElementHelper((OMElement)this);
        return helper.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        OMElement clonedElement = new StAXOMBuilder(this.getXMLStreamReader(true)).getDocumentElement();
        clonedElement.build();
        return clonedElement;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

