/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.soap.impl.llom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.ws.commons.om.OMConstants;
import org.apache.ws.commons.om.OMContainer;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMException;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMNode;
import org.apache.ws.commons.om.OMXMLParserWrapper;
import org.apache.ws.commons.om.impl.OMNodeEx;
import org.apache.ws.commons.om.impl.OMOutputImpl;
import org.apache.ws.commons.om.impl.llom.OMElementImpl;
import org.apache.ws.commons.om.impl.llom.OMSerializerUtil;
import org.apache.ws.commons.om.impl.serialize.StreamWriterToContentHandlerConverter;
import org.apache.ws.commons.soap.SOAPBody;
import org.apache.ws.commons.soap.SOAPFactory;
import org.apache.ws.commons.soap.SOAPFault;
import org.apache.ws.commons.soap.SOAPFaultCode;
import org.apache.ws.commons.soap.SOAPFaultDetail;
import org.apache.ws.commons.soap.SOAPFaultNode;
import org.apache.ws.commons.soap.SOAPFaultReason;
import org.apache.ws.commons.soap.SOAPFaultRole;
import org.apache.ws.commons.soap.SOAPProcessingException;
import org.apache.ws.commons.soap.impl.llom.SOAPElement;
import org.apache.ws.commons.soap.impl.llom.SOAPFaultRoleImpl;

public abstract class SOAPFaultImpl
extends SOAPElement
implements SOAPFault,
OMConstants {
    protected Exception e;

    protected SOAPFaultImpl(OMNamespace ns, SOAPFactory factory) {
        super("Fault", ns, factory);
    }

    public SOAPFaultImpl(SOAPBody parent, Exception e, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)parent, "Fault", true, factory);
        this.setException(e);
    }

    public void setException(Exception e) {
        this.e = e;
        this.putExceptionToSOAPFault(e);
    }

    public SOAPFaultImpl(SOAPBody parent, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)parent, "Fault", true, factory);
    }

    public SOAPFaultImpl(SOAPBody parent, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)parent, "Fault", builder, factory);
    }

    protected abstract SOAPFaultDetail getNewSOAPFaultDetail(SOAPFault var1) throws SOAPProcessingException;

    public void setCode(SOAPFaultCode soapFaultCode) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getCode(), (OMElement)soapFaultCode);
    }

    public SOAPFaultCode getCode() {
        return (SOAPFaultCode)this.getChildWithName("Code");
    }

    public void setReason(SOAPFaultReason reason) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getReason(), (OMElement)reason);
    }

    public SOAPFaultReason getReason() {
        return (SOAPFaultReason)this.getChildWithName("Reason");
    }

    public void setNode(SOAPFaultNode node) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getNode(), (OMElement)node);
    }

    public SOAPFaultNode getNode() {
        return (SOAPFaultNode)this.getChildWithName("Node");
    }

    public void setRole(SOAPFaultRole role) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getRole(), (OMElement)role);
    }

    public SOAPFaultRole getRole() {
        return (SOAPFaultRoleImpl)this.getChildWithName("Role");
    }

    public void setDetail(SOAPFaultDetail detail) throws SOAPProcessingException {
        this.setNewElement((OMElement)this.getDetail(), (OMElement)detail);
    }

    public SOAPFaultDetail getDetail() {
        return (SOAPFaultDetail)this.getChildWithName("Detail");
    }

    public Exception getException() throws OMException {
        SOAPFaultDetail detail = this.getDetail();
        if (detail == null) {
            return null;
        }
        OMElement exceptionElement = this.getDetail().getFirstChildWithName(new QName("Exception"));
        if (exceptionElement != null && exceptionElement.getText() != null) {
            return new Exception(exceptionElement.getText());
        }
        return null;
    }

    protected void putExceptionToSOAPFault(Exception e) throws SOAPProcessingException {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sw.flush();
        SOAPFaultDetail detail = this.getDetail();
        if (this.getDetail() == null) {
            detail = this.getNewSOAPFaultDetail(this);
            this.setDetail(detail);
        }
        OMElementImpl faultDetailEnty = new OMElementImpl("Exception", null, (OMContainer)detail, this.factory);
        faultDetailEnty.setText(sw.getBuffer().toString());
    }

    protected void setNewElement(OMElement myElement, OMElement newElement) {
        if (myElement != null) {
            myElement.discard();
        }
        if (newElement != null && newElement.getParent() != null) {
            newElement.discard();
        }
        this.addChild((OMNode)newElement);
        myElement = newElement;
    }

    protected OMElement getChildWithName(String childName) {
        Iterator childrenIter = this.getChildren();
        while (childrenIter.hasNext()) {
            OMNode node = (OMNode)childrenIter.next();
            if (node.getType() != 1 || !childName.equals(((OMElement)node).getLocalName())) continue;
            return (OMElement)node;
        }
        return null;
    }

    protected void serialize(OMOutputImpl omOutput, boolean cache) throws XMLStreamException {
        SOAPFaultDetail faultDetail;
        SOAPFaultReason faultReason;
        short builderType = 1;
        if (this.builder != null) {
            builderType = this.builder.getBuilderType();
        }
        if (builderType == 0 && this.builder.getRegisteredContentHandler() == null) {
            this.builder.registerExternalContentHandler((Object)new StreamWriterToContentHandlerConverter(omOutput));
        }
        this.build();
        OMSerializerUtil.serializeStartpart(this, omOutput);
        SOAPFaultCode faultCode = this.getCode();
        if (faultCode != null) {
            ((OMNodeEx)faultCode).serialize(omOutput);
        }
        if ((faultReason = this.getReason()) != null) {
            ((OMNodeEx)faultReason).serialize(omOutput);
        }
        this.serializeFaultNode(omOutput);
        SOAPFaultRole faultRole = this.getRole();
        if (faultRole != null && faultRole.getText() != null && !"".equals(faultRole.getText())) {
            ((OMNodeEx)faultRole).serialize(omOutput);
        }
        if ((faultDetail = this.getDetail()) != null) {
            ((OMNodeEx)faultDetail).serialize(omOutput);
        }
        OMSerializerUtil.serializeEndpart(omOutput);
    }

    protected abstract void serializeFaultNode(OMOutputImpl var1) throws XMLStreamException;
}

