/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.soap.impl.llom;

import org.apache.ws.commons.om.OMConstants;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMException;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMNode;
import org.apache.ws.commons.om.OMXMLParserWrapper;
import org.apache.ws.commons.soap.SOAPBody;
import org.apache.ws.commons.soap.SOAPEnvelope;
import org.apache.ws.commons.soap.SOAPFactory;
import org.apache.ws.commons.soap.SOAPFault;
import org.apache.ws.commons.soap.SOAPProcessingException;
import org.apache.ws.commons.soap.impl.llom.SOAPElement;
import org.apache.ws.commons.soap.impl.llom.SOAPEnvelopeImpl;

public abstract class SOAPBodyImpl
extends SOAPElement
implements SOAPBody,
OMConstants {
    private boolean hasSOAPFault = false;

    protected SOAPBodyImpl(String localName, OMNamespace ns, SOAPFactory factory) {
        super(localName, ns, factory);
    }

    public SOAPBodyImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Body", true, factory);
    }

    public SOAPBodyImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)envelope, "Body", builder, factory);
    }

    public abstract SOAPFault addFault(Exception var1) throws OMException;

    public boolean hasFault() {
        if (this.hasSOAPFault) {
            return true;
        }
        OMElement element = this.getFirstElement();
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getName()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getName()))) {
            this.hasSOAPFault = true;
            return true;
        }
        return false;
    }

    public SOAPFault getFault() {
        OMElement element = this.getFirstElement();
        if (this.hasSOAPFault) {
            return (SOAPFault)element;
        }
        if (element != null && "Fault".equals(element.getLocalName()) && ("http://schemas.xmlsoap.org/soap/envelope/".equals(element.getNamespace().getName()) || "http://www.w3.org/2003/05/soap-envelope".equals(element.getNamespace().getName()))) {
            this.hasSOAPFault = true;
            return (SOAPFault)element;
        }
        return null;
    }

    public void addFault(SOAPFault soapFault) throws OMException {
        if (this.hasSOAPFault) {
            throw new OMException("SOAP Body already has a SOAP Fault and there can not be more than one SOAP fault");
        }
        this.addChild((OMNode)soapFault);
        this.hasSOAPFault = true;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }

    public OMNode detach() throws OMException {
        throw new SOAPProcessingException("Can not detach SOAP Body, SOAP Envelope must have a Body !!");
    }
}

