/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.om.util;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.ws.commons.om.OMElement;
import org.apache.ws.commons.om.OMNamespace;
import org.apache.ws.commons.om.OMNode;

public class ElementHelper {
    private OMElement element;

    public ElementHelper(OMElement element) {
        this.element = element;
    }

    public QName resolveQName(String qname, boolean defaultToParentNameSpace) {
        int colon = qname.indexOf(58);
        if (colon < 0) {
            if (defaultToParentNameSpace) {
                OMNamespace namespace = this.element.getNamespace();
                return new QName(namespace.getName(), qname, namespace.getPrefix());
            }
            return new QName(qname);
        }
        String prefix = qname.substring(0, colon);
        String local = qname.substring(colon + 1);
        if (local.length() == 0) {
            return null;
        }
        OMNamespace namespace = this.element.findNamespaceURI(prefix);
        if (namespace == null) {
            return null;
        }
        return new QName(namespace.getName(), local, prefix);
    }

    public QName resolveQName(String qname) {
        return this.resolveQName(qname, true);
    }

    public static void setNewElement(OMElement parent, OMElement myElement, OMElement newElement) {
        if (myElement != null) {
            myElement.discard();
        }
        parent.addChild(newElement);
        myElement = newElement;
    }

    public static OMElement getChildWithName(OMElement parent, String childName) {
        Iterator childrenIter = parent.getChildren();
        while (childrenIter.hasNext()) {
            OMNode node = (OMNode)childrenIter.next();
            if (node.getType() != 1 || !childName.equals(((OMElement)node).getLocalName())) continue;
            return (OMElement)node;
        }
        return null;
    }
}

