/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.web.component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import world.xuewei.fast.core.util.TemplateUtils;
import world.xuewei.fast.web.component.AppInfo;

@Component
public class EmailClient {
    private static final Logger log = LoggerFactory.getLogger(EmailClient.class);
    private final JavaMailSenderImpl mailSender;
    @Value(value="${spring.mail.title:Xw-Fast}")
    private String title = "";
    private final AppInfo appInfo;
    @Value(value="${spring.mail.valid-minutes:5}")
    public Integer validMinutes;

    public EmailClient(@Autowired(required=false) JavaMailSenderImpl javaMailSender, AppInfo appInfo) {
        this.mailSender = javaMailSender;
        this.appInfo = appInfo;
    }

    public void sendEmail(String subject, String content, String targetEmail) throws MessagingException {
        MimeMessage mailMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true);
        messageHelper.setSubject(subject);
        messageHelper.setText(content, true);
        messageHelper.setTo(targetEmail);
        messageHelper.setFrom(String.format("%s<%s>", this.title, this.mailSender.getUsername()));
        this.mailSender.send(mailMessage);
    }

    public void sendCode(String targetEmail, String code) throws MessagingException {
        String codeTemplate = TemplateUtils.readTemplateFile((String)"code");
        codeTemplate = codeTemplate.replace("{CODE}", code);
        codeTemplate = codeTemplate.replace("{VALID_MINUTES}", String.valueOf(this.validMinutes));
        codeTemplate = codeTemplate.replace("{APP_NAME}", this.appInfo.getCnName());
        codeTemplate = codeTemplate.replace("{TIME}", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
        this.sendEmail("\u90ae\u7bb1\u9a8c\u8bc1", codeTemplate, targetEmail);
    }
}

