/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.web.dto.response;

import world.xuewei.fast.core.util.Assert;

public class RespResult {
    protected String code;
    protected String message;
    protected Object data;

    public static RespResult success() {
        return RespResult.builder().code("SUCCESS").message("\u8bf7\u6c42\u6210\u529f").build();
    }

    public static RespResult success(String message) {
        return RespResult.builder().code("SUCCESS").message(message).build();
    }

    public static RespResult success(String message, Object data) {
        return RespResult.builder().code("SUCCESS").message(message).data(data).build();
    }

    public static RespResult notFound() {
        return RespResult.builder().code("NOT_FOUND").message("\u8bf7\u6c42\u8d44\u6e90\u4e0d\u5b58\u5728").build();
    }

    public static RespResult notFound(String message) {
        return RespResult.builder().code("NOT_FOUND").message(String.format("%s\u4e0d\u5b58\u5728", message)).build();
    }

    public static RespResult notFound(String message, Object data) {
        return RespResult.builder().code("NOT_FOUND").message(String.format("%s\u4e0d\u5b58\u5728", message)).data(data).build();
    }

    public static RespResult paramEmpty() {
        return RespResult.builder().code("PARAM_EMPTY").message("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a").build();
    }

    public static RespResult paramEmpty(String message) {
        return RespResult.builder().code("PARAM_EMPTY").message(String.format("%s\u53c2\u6570\u4e3a\u7a7a", message)).build();
    }

    public static RespResult paramEmpty(String message, Object data) {
        return RespResult.builder().code("PARAM_EMPTY").message(String.format("%s\u53c2\u6570\u4e3a\u7a7a", message)).data(data).build();
    }

    public static RespResult fail() {
        return RespResult.builder().code("FAIL").message("\u8bf7\u6c42\u5931\u8d25").build();
    }

    public static RespResult fail(String message) {
        return RespResult.builder().code("FAIL").message(message).build();
    }

    public static RespResult fail(String message, Object data) {
        return RespResult.builder().code("FAIL").message(message).data(data).build();
    }

    public boolean yesSuccess() {
        return "SUCCESS".equals(this.code);
    }

    public boolean yesSuccessWithDateResp() {
        return "SUCCESS".equals(this.code) && Assert.notEmpty((Object)this.data);
    }

    public boolean notSuccess() {
        return !this.yesSuccess();
    }

    public static RespResultBuilder builder() {
        return new RespResultBuilder();
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RespResult)) {
            return false;
        }
        RespResult other = (RespResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RespResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "RespResult(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public RespResult() {
    }

    public RespResult(String code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static class RespResultBuilder {
        private String code;
        private String message;
        private Object data;

        RespResultBuilder() {
        }

        public RespResultBuilder code(String code) {
            this.code = code;
            return this;
        }

        public RespResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RespResultBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public RespResult build() {
            return new RespResult(this.code, this.message, this.data);
        }

        public String toString() {
            return "RespResult.RespResultBuilder(code=" + this.code + ", message=" + this.message + ", data=" + this.data + ")";
        }
    }
}

