/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.web.component;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import world.xuewei.fast.core.exception.AuthorityException;
import world.xuewei.fast.core.exception.BusinessException;
import world.xuewei.fast.core.exception.BusinessRunTimeException;
import world.xuewei.fast.core.exception.ParamEmptyException;
import world.xuewei.fast.core.exception.ServerBusyException;
import world.xuewei.fast.web.dto.response.RespError;
import world.xuewei.fast.web.dto.response.RespResult;

@RestControllerAdvice
public class RestExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={ServerBusyException.class})
    public RespResult handleBusinessException(BusinessException e, HttpServletRequest request) {
        log.error("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        RespError error = new RespError();
        error.setCode("SERVER_BUSY");
        error.setMessage("\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        error.setRequestUrl(request.getRequestURL().toString());
        error.setException(e.getClass().getName());
        return error;
    }

    @ExceptionHandler(value={AuthorityException.class})
    public RespResult handleAuthorityException(AuthorityException e, HttpServletRequest request) {
        log.error("\u64cd\u4f5c\u6743\u9650\u4e0d\u8db3\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        RespError error = new RespError();
        error.setCode("NO_AUTHORITY");
        error.setMessage("\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee");
        error.setRequestUrl(request.getRequestURL().toString());
        error.setException(e.getClass().getName());
        return error;
    }

    @ExceptionHandler(value={ParamEmptyException.class})
    public RespResult handleParamEmptyException(ParamEmptyException e, HttpServletRequest request) {
        log.error("\u53c2\u6570\u4e3a\u7a7a\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        RespError error = new RespError();
        error.setCode("PARAM_EMPTY");
        error.setMessage(e.getMessage());
        error.setRequestUrl(request.getRequestURL().toString());
        error.setException(e.getClass().getName());
        return error;
    }

    @ExceptionHandler(value={BusinessRunTimeException.class, BusinessException.class, Exception.class, RuntimeException.class})
    public RespResult handleBusinessException(Exception e, HttpServletRequest request) {
        log.error("\u4e1a\u52a1\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        RespError error = new RespError();
        error.setCode("FAIL");
        error.setMessage("\u7cfb\u7edf\u5f02\u5e38");
        error.setData(e.getMessage());
        error.setRequestUrl(request.getRequestURL().toString());
        error.setException(e.getClass().getName());
        if (error.getException().contains("HttpMessageNotReadableException")) {
            error.setMessage("\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        return error;
    }
}

