/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.crud.config;

import cn.hutool.core.util.ObjectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import world.xuewei.fast.crud.annotation.FastController;
import world.xuewei.fast.crud.controller.BaseController;
import world.xuewei.fast.crud.service.BaseDBService;

@Configuration
public class FastControllerRegister
implements ApplicationContextAware,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(FastControllerRegister.class);
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Bean
    public String registerFastController(RequestMappingHandlerMapping handlerMapping) {
        Map fastMap = this.context.getBeansWithAnnotation(FastController.class);
        for (String beanName : fastMap.keySet()) {
            Object fastController = fastMap.get(beanName);
            Class<?> fastClass = fastController.getClass();
            RequestMapping requestMappingAnnotation = fastClass.getAnnotation(RequestMapping.class);
            if (ObjectUtil.isEmpty((Object)requestMappingAnnotation)) {
                log.warn("FastController Must Be Tagged With @RequestMapping. {} Fail To Register", (Object)beanName);
                continue;
            }
            String[] basicUrls = requestMappingAnnotation.value();
            if (ObjectUtil.isEmpty((Object)basicUrls)) {
                log.warn("FastController @RequestMapping Url Must Be Specify. {} Fail To Register", (Object)beanName);
                continue;
            }
            BaseDBService<Object> service = this.getService(fastClass, fastController);
            if (ObjectUtil.isEmpty(service)) {
                log.warn("FastController Must Inject A Member Variable Named 'service'. {} Fail To Register", (Object)beanName);
                continue;
            }
            FastController classAnnotation = fastClass.getAnnotation(FastController.class);
            String[] includeMethods = classAnnotation.includeMethods();
            String[] excludeMethods = classAnnotation.excludeMethods();
            if (ObjectUtil.isNotEmpty((Object)includeMethods) && ObjectUtil.isNotEmpty((Object)excludeMethods)) {
                log.warn("FastController Cannot Configure Both 'includeMethods' and 'excludeMethods'. {} Fail To Register", (Object)beanName);
                continue;
            }
            RequestMappingInfo.BuilderConfiguration initConfig = this.initConfig(handlerMapping);
            BaseController<Object> baseController = new BaseController<Object>(service);
            Set<Method> methods = this.getNeedRegisterMethods(includeMethods, excludeMethods);
            for (Method method : methods) {
                for (String basicUrl : basicUrls) {
                    this.doRegister(initConfig, handlerMapping, basicUrl, baseController, method);
                }
            }
        }
        return null;
    }

    private Set<Method> getNeedRegisterMethods(String[] includeMethods, String[] excludeMethods) {
        List<String> includeList = Arrays.stream(includeMethods).collect(Collectors.toList());
        List<String> excludeList = Arrays.stream(excludeMethods).collect(Collectors.toList());
        List<Method> methodList = Arrays.stream(BaseController.class.getDeclaredMethods()).collect(Collectors.toList());
        return ObjectUtil.isNotEmpty((Object)includeMethods) ? this.includeRegister(includeList, methodList) : this.excludeRegister(excludeList, methodList);
    }

    private Set<Method> includeRegister(List<String> includeList, List<Method> allMethods) {
        LinkedHashSet<Method> methodSet = new LinkedHashSet<Method>();
        block0: for (Method method : allMethods) {
            String methodName = method.getName();
            if (includeList.contains(methodName)) {
                methodSet.add(method);
                continue;
            }
            for (String s : includeList) {
                if (!FastControllerRegister.eligibleStar(methodName, s)) continue;
                methodSet.add(method);
                continue block0;
            }
        }
        return methodSet;
    }

    private Set<Method> excludeRegister(List<String> excludeList, List<Method> allMethods) {
        LinkedHashSet<Method> methodSet = new LinkedHashSet<Method>(allMethods);
        Iterator iterator = methodSet.iterator();
        block0: while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            String methodName = method.getName();
            if (excludeList.contains(methodName)) {
                iterator.remove();
                continue;
            }
            for (String s : excludeList) {
                if (!FastControllerRegister.eligibleStar(methodName, s)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return methodSet;
    }

    private static boolean eligibleStar(String methodName, String rule) {
        return methodName.matches(rule.replace("*", ".*"));
    }

    private void doRegister(RequestMappingInfo.BuilderConfiguration config, RequestMappingHandlerMapping handlerMapping, String requestMapping, Object handler, Method method) {
        String path = String.format("%s/%s", requestMapping, method.getName());
        handlerMapping.registerMapping(RequestMappingInfo.paths((String[])new String[]{path}).options(config).build(), handler, method);
        log.info("FastController Interface Successfully Registered. Path {}", (Object)path);
    }

    private RequestMappingInfo.BuilderConfiguration initConfig(RequestMappingHandlerMapping handlerMapping) {
        RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();
        config.setTrailingSlashMatch(handlerMapping.useTrailingSlashMatch());
        config.setContentNegotiationManager(handlerMapping.getContentNegotiationManager());
        if (handlerMapping.getPatternParser() != null) {
            config.setPatternParser(handlerMapping.getPatternParser());
        } else {
            config.setSuffixPatternMatch(handlerMapping.useSuffixPatternMatch());
            config.setRegisteredSuffixPatternMatch(handlerMapping.useRegisteredSuffixPatternMatch());
            config.setPathMatcher(handlerMapping.getPathMatcher());
        }
        return config;
    }

    private BaseDBService<Object> getService(Class<?> fastClass, Object fastController) {
        Object serviceInstance;
        try {
            Field serviceField = fastClass.getDeclaredField("service");
            serviceField.setAccessible(true);
            serviceInstance = serviceField.get(fastController);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
        return ObjectUtil.isNotEmpty((Object)serviceInstance) ? (BaseDBService)serviceInstance : null;
    }
}

