/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.crud.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import world.xuewei.fast.core.exception.BusinessRunTimeException;
import world.xuewei.fast.core.exception.ParamEmptyException;
import world.xuewei.fast.crud.dto.request.ReqBody;
import world.xuewei.fast.crud.query.QueryBody;
import world.xuewei.fast.crud.query.ResultPage;
import world.xuewei.fast.crud.service.BaseDBService;
import world.xuewei.fast.web.dto.response.RespResult;

public class BaseController<T> {
    protected final BaseDBService<T> baseService;

    public BaseController(BaseDBService<T> baseService) {
        this.baseService = baseService;
    }

    @PostMapping(value={"/saveData"})
    @ResponseBody
    public RespResult saveData(@RequestBody ReqBody<T> reqBody) {
        Object obj = Assert.notNull(reqBody.getObj(), () -> ParamEmptyException.build((String)"\u5b9e\u4f53[obj]"));
        return RespResult.success((String)"\u65b0\u589e\u6210\u529f", (Object)this.baseService.saveData(obj));
    }

    @PostMapping(value={"/saveBatchData"})
    @ResponseBody
    public RespResult saveBatchData(@RequestBody ReqBody<T> reqBody) {
        List objs = (List)Assert.notEmpty(reqBody.getObjs(), () -> ParamEmptyException.build((String)"\u5b9e\u4f53\u6570\u7ec4[objs]"));
        return RespResult.success((String)"\u65b0\u589e\u6210\u529f", this.baseService.saveBatchData(objs));
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public RespResult delete(@RequestBody ReqBody<T> reqBody) {
        Serializable id = (Serializable)Assert.notNull((Object)reqBody.getId(), () -> ParamEmptyException.build((String)"ID[id]"));
        int deleted = this.baseService.delete(id);
        return deleted == 0 ? RespResult.notFound((String)"\u76ee\u6807") : RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @PostMapping(value={"/deleteBatch"})
    @ResponseBody
    public RespResult deleteBatch(@RequestBody ReqBody<T> reqBody) {
        List ids = (List)Assert.notEmpty(reqBody.getIds(), () -> ParamEmptyException.build((String)"ID\u6570\u7ec4[ids]"));
        int deleted = this.baseService.deleteBatch(ids);
        return deleted == 0 ? RespResult.notFound((String)"\u76ee\u6807") : RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @PostMapping(value={"/deleteByField"})
    @ResponseBody
    public RespResult deleteByField(@RequestBody ReqBody<T> reqBody) {
        Object value;
        String field = (String)Assert.notNull((Object)reqBody.getField(), () -> ParamEmptyException.build((String)"\u5b57\u6bb5[field]"));
        int deleted = this.baseService.deleteByField(field, value = Assert.notNull((Object)reqBody.getValue(), () -> ParamEmptyException.build((String)"\u503c[value]")));
        return deleted == 0 ? RespResult.notFound((String)"\u76ee\u6807") : RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @PostMapping(value={"/deleteBatchByField"})
    @ResponseBody
    public RespResult deleteBatchByField(@RequestBody ReqBody<T> reqBody) {
        List values;
        String field = (String)Assert.notNull((Object)reqBody.getField(), () -> ParamEmptyException.build((String)"\u5b57\u6bb5[field]"));
        int deleted = this.baseService.deleteBatchByField(field, values = (List)Assert.notEmpty(reqBody.getValues(), () -> ParamEmptyException.build((String)"\u503c\u6570\u7ec4[values]")));
        return deleted == 0 ? RespResult.notFound((String)"\u76ee\u6807") : RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @PostMapping(value={"/getById"})
    @ResponseBody
    public RespResult getById(@RequestBody ReqBody<T> reqBody) {
        Serializable id = (Serializable)Assert.notNull((Object)reqBody.getId(), () -> ParamEmptyException.build((String)"ID[id]"));
        T t = this.baseService.getById(id);
        return ObjectUtil.isEmpty(t) ? RespResult.notFound((String)"\u76ee\u6807") : RespResult.success((String)"\u67e5\u8be2\u6210\u529f", t);
    }

    @PostMapping(value={"/getByIds"})
    @ResponseBody
    public RespResult getByIds(@RequestBody ReqBody<T> reqBody) {
        List ids = (List)Assert.notEmpty(reqBody.getIds(), () -> ParamEmptyException.build((String)"ID\u6570\u7ec4[ids]"));
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", this.baseService.getByIds(ids));
    }

    @PostMapping(value={"/getByObj"})
    @ResponseBody
    public RespResult getByObj(@RequestBody ReqBody<T> reqBody) {
        Object obj = Assert.notNull(reqBody.getObj(), () -> ParamEmptyException.build((String)"\u5b9e\u4f53[obj]"));
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", this.baseService.getByObj(obj));
    }

    @PostMapping(value={"/getByField"})
    @ResponseBody
    public RespResult getByField(@RequestBody ReqBody<T> reqBody) {
        String field = (String)Assert.notNull((Object)reqBody.getField(), () -> ParamEmptyException.build((String)"\u5b57\u6bb5[field]"));
        Object value = Assert.notNull((Object)reqBody.getValue(), () -> ParamEmptyException.build((String)"\u503c[value]"));
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", this.baseService.getByField(field, value));
    }

    @PostMapping(value={"/getBatchByField"})
    @ResponseBody
    public RespResult getBatchByField(@RequestBody ReqBody<T> reqBody) {
        String field = (String)Assert.notNull((Object)reqBody.getField(), () -> ParamEmptyException.build((String)"\u5b57\u6bb5[field]"));
        List values = (List)Assert.notEmpty(reqBody.getValues(), () -> ParamEmptyException.build((String)"\u503c\u6570\u7ec4[values]"));
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", this.baseService.getBatchByField(field, values));
    }

    @PostMapping(value={"/getAll"})
    @ResponseBody
    public RespResult getAll() {
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", this.baseService.getAll());
    }

    @PostMapping(value={"/customQuery"})
    @ResponseBody
    public RespResult customQuery(@RequestBody ReqBody<T> reqBody) {
        QueryBody queryBody = (QueryBody)Assert.notNull(reqBody.getQueryBody(), () -> ParamEmptyException.build((String)"\u67e5\u8be2\u7b56\u7565[queryBody]"));
        queryBody.check();
        QueryWrapper queryWrapper = queryBody.buildWrapper();
        IPage page = queryBody.buildPage();
        try {
            if (ObjectUtil.isNotEmpty(page)) {
                IPage<T> wrapperPage = this.baseService.getByWrapperPage(queryWrapper, page);
                ResultPage<T> resultPage = new ResultPage<T>(wrapperPage);
                return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", resultPage);
            }
            List<T> byWrapper = this.baseService.getByWrapper(queryWrapper);
            return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", byWrapper);
        }
        catch (BadSqlGrammarException e) {
            throw new BusinessRunTimeException("\u67e5\u8be2\u5931\u8d25\uff1a{}", new Object[]{e.getMessage()});
        }
    }

    @PostMapping(value={"/countByObj"})
    @ResponseBody
    public RespResult countByObj(@RequestBody ReqBody<T> reqBody) {
        Object obj = Assert.notNull(reqBody.getObj(), () -> ParamEmptyException.build((String)"\u5b9e\u4f53[obj]"));
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.baseService.countByObj(obj));
    }

    @PostMapping(value={"/countByField"})
    @ResponseBody
    public RespResult countByField(@RequestBody ReqBody<T> reqBody) {
        String field = (String)Assert.notNull((Object)reqBody.getField(), () -> ParamEmptyException.build((String)"\u5b57\u6bb5[field]"));
        Object value = Assert.notNull((Object)reqBody.getValue(), () -> ParamEmptyException.build((String)"\u503c[value]"));
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", (Object)this.baseService.countByField(field, value));
    }
}

