/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.crud.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;
import world.xuewei.fast.core.util.Assert;
import world.xuewei.fast.core.util.BeanUtils;
import world.xuewei.fast.core.util.VariableNameUtils;
import world.xuewei.fast.crud.service.BaseDBInterface;

public class BaseDBService<T>
extends ServiceImpl<BaseMapper<T>, T>
implements BaseDBInterface<T> {
    private final BaseMapper<T> mapper;

    public BaseDBService(BaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public T saveData(T obj) {
        super.saveOrUpdate(obj);
        return obj;
    }

    @Override
    public List<T> saveBatchData(T[] array) {
        List objList = Arrays.stream(array).collect(Collectors.toList());
        return this.saveBatchData(objList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<T> saveBatchData(Collection<T> list) {
        list.forEach(this::saveData);
        return new ArrayList<T>(list);
    }

    @Override
    public T insert(T obj) {
        this.mapper.insert(obj);
        return obj;
    }

    @Override
    public List<T> insertBatch(T[] array) {
        List objList = Arrays.stream(array).collect(Collectors.toList());
        return this.insertBatch(objList);
    }

    @Override
    public List<T> insertBatch(Collection<T> list) {
        super.saveBatch(list);
        return new ArrayList<T>(list);
    }

    @Override
    public T update(T obj) {
        this.mapper.updateById(obj);
        return obj;
    }

    @Override
    public List<T> updateBatch(T[] array) {
        List objList = Arrays.stream(array).collect(Collectors.toList());
        return this.updateBatch(objList);
    }

    @Override
    public List<T> updateBatch(Collection<T> list) {
        super.updateBatchById(list);
        return new ArrayList<T>(list);
    }

    @Override
    public int delete(Serializable id) {
        return this.mapper.deleteById(id);
    }

    @Override
    public int deleteBatch(Serializable[] ids) {
        List idList = Arrays.stream(ids).collect(Collectors.toList());
        return this.deleteBatch(idList);
    }

    @Override
    public int deleteBatch(Collection<? extends Serializable> ids) {
        return this.mapper.deleteBatchIds(ids);
    }

    @Override
    public int deleteByField(String field, Object value) {
        return this.mapper.delete((Wrapper)new QueryWrapper().eq((Object)field, value));
    }

    @Override
    public int deleteBatchByField(String field, Object[] values) {
        return this.mapper.delete((Wrapper)new QueryWrapper().in((Object)field, values));
    }

    @Override
    public int deleteBatchByField(String field, List<Object> values) {
        return this.deleteBatchByField(field, values.toArray());
    }

    @Override
    public T getById(Serializable id) {
        return (T)this.mapper.selectById(id);
    }

    @Override
    public List<T> getByIds(Serializable[] ids) {
        List idList = Arrays.stream(ids).collect(Collectors.toList());
        return this.getByIds(idList);
    }

    @Override
    public List<T> getByIds(Collection<? extends Serializable> ids) {
        return this.mapper.selectBatchIds(ids);
    }

    @Override
    public List<T> getAll() {
        return super.list();
    }

    @Override
    public List<T> getByWrapper(Wrapper<T> wrapper) {
        return this.mapper.selectList(wrapper);
    }

    @Override
    public List<T> getByField(String field, Object value) {
        return this.mapper.selectList((Wrapper)new QueryWrapper().eq((Object)field, value));
    }

    @Override
    public List<T> getBatchByField(String field, Object[] values) {
        return this.mapper.selectList((Wrapper)new QueryWrapper().in((Object)field, values));
    }

    @Override
    public List<T> getBatchByField(String field, List<Object> values) {
        return this.getBatchByField(field, values.toArray());
    }

    @Override
    public List<T> getByObj(T obj) {
        if (Assert.isEmpty(obj)) {
            return this.getAll();
        }
        Map bean2Map = BeanUtils.beanToMap(obj);
        return this.getByMap(bean2Map);
    }

    @Override
    public List<T> getByMap(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            if (Assert.isEmpty((Object)map.get(key))) continue;
            newMap.put(VariableNameUtils.humpToLine((String)key), map.get(key));
        }
        return this.mapper.selectByMap(newMap);
    }

    @Override
    public int countAll() {
        return super.count();
    }

    @Override
    public int countByField(String field, Object value) {
        return this.mapper.selectCount((Wrapper)new QueryWrapper().eq((Object)field, value));
    }

    @Override
    public int countByWrapper(Wrapper<T> wrapper) {
        return this.mapper.selectCount(wrapper);
    }

    @Override
    public int countByObj(T obj) {
        return this.countByMap(BeanUtils.beanToMap(obj));
    }

    @Override
    public int countByMap(Map<String, Object> map) {
        return this.mapper.selectCount(this.createWrapperFromMap(map));
    }

    @Override
    public IPage<T> getByWrapperPage(Wrapper<T> wrapper, IPage<T> page) {
        return this.mapper.selectPage(page, wrapper);
    }

    @Override
    public IPage<T> getByObjPage(T obj, IPage<T> page) {
        return this.getByMapPage(BeanUtils.beanToMap(obj), page);
    }

    @Override
    public IPage<T> getByMapPage(Map<String, Object> map, IPage<T> page) {
        return this.getByWrapperPage((Wrapper<T>)this.createWrapperFromMap(map), page);
    }

    private QueryWrapper<T> createWrapperFromMap(Map<String, Object> map) {
        QueryWrapper wrapper = new QueryWrapper();
        for (Map.Entry<String, Object> temp : map.entrySet()) {
            String key = temp.getKey();
            if (Assert.isEmpty((Object)temp.getValue())) continue;
            wrapper.eq((Object)VariableNameUtils.humpToLine((String)key), map.get(key));
        }
        return wrapper;
    }
}

