/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.crud.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;
import java.util.stream.Collectors;
import world.xuewei.fast.core.exception.BusinessRunTimeException;
import world.xuewei.fast.core.util.Assert;
import world.xuewei.fast.core.util.VariableNameUtils;
import world.xuewei.fast.crud.query.QueryCondition;
import world.xuewei.fast.crud.query.QueryOrder;
import world.xuewei.fast.crud.query.QueryPage;

public class QueryBody<T> {
    private String keyword;
    private List<String> keywordFields;
    private List<String> includeFields;
    private List<QueryCondition> conditions;
    private List<QueryOrder> orderBy;
    private QueryPage pageBy;

    public void check() {
        if (Assert.notEmpty((CharSequence)this.keyword) && Assert.isEmpty(this.keywordFields)) {
            throw new BusinessRunTimeException("\u5173\u952e\u8bcd\u67e5\u8be2\u65f6\u5fc5\u987b\u6307\u5b9a keywordFields\uff0c\u4e14\u5fc5\u987b\u6307\u5b9a\u4e3a\u5b57\u7b26\u7c7b\u578b\u5b57\u6bb5", new Object[0]);
        }
        if (Assert.notEmpty(this.conditions)) {
            this.conditions.forEach(QueryCondition::check);
        }
        if (Assert.notEmpty(this.orderBy)) {
            this.orderBy.forEach(QueryOrder::check);
        }
    }

    public QueryWrapper<T> buildWrapper() {
        String type;
        String field;
        QueryWrapper wrapper = new QueryWrapper();
        if (Assert.notEmpty(this.keywordFields) && Assert.notEmpty((CharSequence)this.keyword)) {
            wrapper.and(orWrapper -> {
                for (String keywordField : this.keywordFields) {
                    ((QueryWrapper)orWrapper.like((Object)VariableNameUtils.humpToLine((String)keywordField), (Object)this.keyword)).or();
                }
            });
        }
        if (Assert.notEmpty(this.includeFields)) {
            String[] array = this.includeFields.stream().map(VariableNameUtils::humpToLine).collect(Collectors.toList()).toArray(new String[0]);
            wrapper.select(array);
        }
        if (Assert.notEmpty(this.conditions)) {
            block52: for (QueryCondition condition : this.conditions) {
                field = VariableNameUtils.humpToLine((String)condition.getField());
                type = condition.getType();
                Object value = condition.getValue();
                if ("ALL_DATA".equals(value)) continue;
                switch (type) {
                    case "eq": {
                        wrapper.eq((Object)field, value);
                        continue block52;
                    }
                    case "ne": {
                        wrapper.ne((Object)field, value);
                        continue block52;
                    }
                    case "gt": {
                        wrapper.gt((Object)field, value);
                        continue block52;
                    }
                    case "ge": {
                        wrapper.ge((Object)field, value);
                        continue block52;
                    }
                    case "lt": {
                        wrapper.lt((Object)field, value);
                        continue block52;
                    }
                    case "le": {
                        wrapper.le((Object)field, value);
                        continue block52;
                    }
                    case "contain": {
                        wrapper.like((Object)field, value);
                        continue block52;
                    }
                    case "notContain": {
                        wrapper.notLike((Object)field, value);
                        continue block52;
                    }
                    case "startWith": {
                        wrapper.likeLeft((Object)field, value);
                        continue block52;
                    }
                    case "endWith": {
                        wrapper.likeRight((Object)field, value);
                        continue block52;
                    }
                    case "isNull": {
                        wrapper.isNull((Object)field);
                        continue block52;
                    }
                    case "isNotNull": {
                        wrapper.isNotNull((Object)field);
                        continue block52;
                    }
                    case "in": {
                        try {
                            wrapper.in((Object)field, this.parseValue2List(value).toArray());
                            continue block52;
                        }
                        catch (JsonProcessingException e) {
                            throw new BusinessRunTimeException("in \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4", new Object[0]);
                        }
                    }
                    case "notIn": {
                        try {
                            wrapper.notIn((Object)field, this.parseValue2List(value).toArray());
                            continue block52;
                        }
                        catch (JsonProcessingException e) {
                            throw new BusinessRunTimeException("notIn \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4", new Object[0]);
                        }
                    }
                    case "between": {
                        List<Object> betweenList;
                        try {
                            betweenList = this.parseValue2List(value);
                            if (betweenList.size() != 2) {
                                throw new BusinessRunTimeException("between \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4\u4e14\u957f\u5ea6\u4e3a 2", new Object[0]);
                            }
                            wrapper.between((Object)field, betweenList.get(0), betweenList.get(1));
                            continue block52;
                        }
                        catch (JsonProcessingException e) {
                            throw new BusinessRunTimeException("between \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4\u4e14\u957f\u5ea6\u4e3a 2", new Object[0]);
                        }
                    }
                    case "notBetween": {
                        List<Object> betweenList;
                        try {
                            betweenList = this.parseValue2List(value);
                            if (betweenList.size() != 2) {
                                throw new BusinessRunTimeException("notBetween \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4\u4e14\u957f\u5ea6\u4e3a 2", new Object[0]);
                            }
                            wrapper.notBetween((Object)field, betweenList.get(0), betweenList.get(1));
                            continue block52;
                        }
                        catch (JsonProcessingException e) {
                            throw new BusinessRunTimeException("notBetween \u64cd\u4f5c\u7684\u503c\u5fc5\u987b\u4e3a\u6570\u7ec4\u4e14\u957f\u5ea6\u4e3a 2", new Object[0]);
                        }
                    }
                }
                throw new BusinessRunTimeException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u64cd\u4f5c\uff1a" + type, new Object[0]);
            }
        }
        if (Assert.notEmpty(this.orderBy)) {
            block53: for (QueryOrder queryOrder : this.orderBy) {
                field = VariableNameUtils.humpToLine((String)queryOrder.getField());
                switch (type = queryOrder.getType().toLowerCase()) {
                    case "asc": {
                        wrapper.orderByAsc((Object)field);
                        continue block53;
                    }
                    case "desc": {
                        wrapper.orderByDesc((Object)field);
                        continue block53;
                    }
                }
                throw new BusinessRunTimeException("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u64cd\u4f5c\uff1a" + type, new Object[0]);
            }
        }
        return wrapper;
    }

    public IPage<T> buildPage() {
        if (Assert.isEmpty((Object)this.pageBy) || Assert.isEmpty((Object)this.pageBy.getPageNum()) && Assert.isEmpty((Object)this.pageBy.getPageSize())) {
            return null;
        }
        if (Assert.isEmpty((Object)this.pageBy.getPageNum()) || Assert.isEmpty((Object)this.pageBy.getPageSize())) {
            throw new BusinessRunTimeException("pageNum \u4e0e pageSize \u5fc5\u987b\u540c\u65f6\u6307\u5b9a", new Object[0]);
        }
        return new Page(this.pageBy.getPageNum().longValue(), this.pageBy.getPageSize().longValue());
    }

    private List<Object> parseValue2List(Object value) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, Object.class);
        return (List)objectMapper.readValue(String.valueOf(value), (JavaType)listType);
    }

    public static <T> QueryBodyBuilder<T> builder() {
        return new QueryBodyBuilder();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public List<String> getKeywordFields() {
        return this.keywordFields;
    }

    public List<String> getIncludeFields() {
        return this.includeFields;
    }

    public List<QueryCondition> getConditions() {
        return this.conditions;
    }

    public List<QueryOrder> getOrderBy() {
        return this.orderBy;
    }

    public QueryPage getPageBy() {
        return this.pageBy;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setKeywordFields(List<String> keywordFields) {
        this.keywordFields = keywordFields;
    }

    public void setIncludeFields(List<String> includeFields) {
        this.includeFields = includeFields;
    }

    public void setConditions(List<QueryCondition> conditions) {
        this.conditions = conditions;
    }

    public void setOrderBy(List<QueryOrder> orderBy) {
        this.orderBy = orderBy;
    }

    public void setPageBy(QueryPage pageBy) {
        this.pageBy = pageBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryBody)) {
            return false;
        }
        QueryBody other = (QueryBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        List<String> this$keywordFields = this.getKeywordFields();
        List<String> other$keywordFields = other.getKeywordFields();
        if (this$keywordFields == null ? other$keywordFields != null : !((Object)this$keywordFields).equals(other$keywordFields)) {
            return false;
        }
        List<String> this$includeFields = this.getIncludeFields();
        List<String> other$includeFields = other.getIncludeFields();
        if (this$includeFields == null ? other$includeFields != null : !((Object)this$includeFields).equals(other$includeFields)) {
            return false;
        }
        List<QueryCondition> this$conditions = this.getConditions();
        List<QueryCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<QueryOrder> this$orderBy = this.getOrderBy();
        List<QueryOrder> other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        QueryPage this$pageBy = this.getPageBy();
        QueryPage other$pageBy = other.getPageBy();
        return !(this$pageBy == null ? other$pageBy != null : !((Object)this$pageBy).equals(other$pageBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        List<String> $keywordFields = this.getKeywordFields();
        result = result * 59 + ($keywordFields == null ? 43 : ((Object)$keywordFields).hashCode());
        List<String> $includeFields = this.getIncludeFields();
        result = result * 59 + ($includeFields == null ? 43 : ((Object)$includeFields).hashCode());
        List<QueryCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<QueryOrder> $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        QueryPage $pageBy = this.getPageBy();
        result = result * 59 + ($pageBy == null ? 43 : ((Object)$pageBy).hashCode());
        return result;
    }

    public String toString() {
        return "QueryBody(keyword=" + this.getKeyword() + ", keywordFields=" + this.getKeywordFields() + ", includeFields=" + this.getIncludeFields() + ", conditions=" + this.getConditions() + ", orderBy=" + this.getOrderBy() + ", pageBy=" + this.getPageBy() + ")";
    }

    public QueryBody() {
    }

    public QueryBody(String keyword, List<String> keywordFields, List<String> includeFields, List<QueryCondition> conditions, List<QueryOrder> orderBy, QueryPage pageBy) {
        this.keyword = keyword;
        this.keywordFields = keywordFields;
        this.includeFields = includeFields;
        this.conditions = conditions;
        this.orderBy = orderBy;
        this.pageBy = pageBy;
    }

    public static class QueryBodyBuilder<T> {
        private String keyword;
        private List<String> keywordFields;
        private List<String> includeFields;
        private List<QueryCondition> conditions;
        private List<QueryOrder> orderBy;
        private QueryPage pageBy;

        QueryBodyBuilder() {
        }

        public QueryBodyBuilder<T> keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public QueryBodyBuilder<T> keywordFields(List<String> keywordFields) {
            this.keywordFields = keywordFields;
            return this;
        }

        public QueryBodyBuilder<T> includeFields(List<String> includeFields) {
            this.includeFields = includeFields;
            return this;
        }

        public QueryBodyBuilder<T> conditions(List<QueryCondition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public QueryBodyBuilder<T> orderBy(List<QueryOrder> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public QueryBodyBuilder<T> pageBy(QueryPage pageBy) {
            this.pageBy = pageBy;
            return this;
        }

        public QueryBody<T> build() {
            return new QueryBody(this.keyword, this.keywordFields, this.includeFields, this.conditions, this.orderBy, this.pageBy);
        }

        public String toString() {
            return "QueryBody.QueryBodyBuilder(keyword=" + this.keyword + ", keywordFields=" + this.keywordFields + ", includeFields=" + this.includeFields + ", conditions=" + this.conditions + ", orderBy=" + this.orderBy + ", pageBy=" + this.pageBy + ")";
        }
    }
}

