/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.crud.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import world.xuewei.fast.core.exception.BusinessRunTimeException;
import world.xuewei.fast.core.util.Assert;
import world.xuewei.fast.crud.dto.request.ReqBody;
import world.xuewei.fast.crud.query.QueryBody;
import world.xuewei.fast.crud.query.ResultPage;
import world.xuewei.fast.crud.service.BaseDBService;
import world.xuewei.fast.web.dto.response.RespResult;

public class BaseController<T> {
    protected final BaseDBService<T> baseService;

    public BaseController(BaseDBService<T> baseService) {
        this.baseService = baseService;
    }

    @RequestMapping(value={"/saveData"})
    @ResponseBody
    public RespResult saveData(@RequestBody ReqBody<T> reqBody) {
        T t = reqBody.getObj();
        Assert.assertNotEmpty(t, (String)"\u5b9e\u4f53[obj]");
        T obj = this.baseService.saveData(t);
        return RespResult.success((String)"\u65b0\u589e\u6210\u529f", obj);
    }

    @RequestMapping(value={"/saveBatchData"})
    @ResponseBody
    public RespResult saveBatchData(@RequestBody ReqBody<T> reqBody) {
        List<T> objs = reqBody.getObjs();
        Assert.assertNotEmpty(objs, (String)"\u5b9e\u4f53\u6570\u7ec4[objs]");
        List<T> tList = this.baseService.saveBatchData(objs);
        return RespResult.success((String)"\u65b0\u589e\u6210\u529f", tList);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public RespResult delete(@RequestBody ReqBody<T> reqBody) {
        Assert.assertNotEmpty(reqBody, (String)"ID[id]");
        Serializable id = reqBody.getId();
        Assert.assertNotEmpty((Object)id, (String)"ID[id]");
        int deleted = this.baseService.delete(id);
        if (deleted == 0) {
            return RespResult.notFound((String)"\u76ee\u6807");
        }
        return RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @RequestMapping(value={"/deleteBatch"})
    @ResponseBody
    public RespResult deleteBatch(@RequestBody ReqBody<T> reqBody) {
        Assert.assertNotEmpty(reqBody, (String)"ID\u6570\u7ec4[ids]");
        List<Serializable> ids = reqBody.getIds();
        Assert.assertNotEmpty(ids, (String)"ID\u6570\u7ec4[ids]");
        int deleted = this.baseService.deleteBatch(ids);
        if (deleted == 0) {
            return RespResult.notFound((String)"\u76ee\u6807");
        }
        return RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @RequestMapping(value={"/deleteByField"})
    @ResponseBody
    public RespResult deleteByField(@RequestBody ReqBody<T> reqBody) {
        String field = reqBody.getField();
        Object value = reqBody.getValue();
        Assert.assertNotEmpty((CharSequence)field, (String)"\u5b57\u6bb5[field]");
        Assert.assertNotEmpty((Object)value, (String)"\u503c[value]");
        int deleted = this.baseService.deleteByField(field, value);
        if (deleted == 0) {
            return RespResult.notFound((String)"\u76ee\u6807");
        }
        return RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @RequestMapping(value={"/deleteBatchByField"})
    @ResponseBody
    public RespResult deleteBatchByField(@RequestBody ReqBody<T> reqBody) {
        String field = reqBody.getField();
        List<Object> values = reqBody.getValues();
        Assert.assertNotEmpty((CharSequence)field, (String)"\u5b57\u6bb5[field]");
        Assert.assertNotEmpty(values, (String)"\u503c\u6570\u7ec4[values]");
        int deleted = this.baseService.deleteBatchByField(field, values);
        if (deleted == 0) {
            return RespResult.notFound((String)"\u76ee\u6807");
        }
        return RespResult.success((String)"\u5220\u9664\u6210\u529f", (Object)deleted);
    }

    @RequestMapping(value={"/getById"})
    @ResponseBody
    public RespResult getById(@RequestBody ReqBody<T> reqBody) {
        Serializable id = reqBody.getId();
        Assert.assertNotEmpty((Object)id, (String)"ID[id]");
        T t = this.baseService.getById(id);
        if (Assert.isEmpty(t)) {
            return RespResult.notFound((String)"\u76ee\u6807");
        }
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", t);
    }

    @RequestMapping(value={"/getByIds"})
    @ResponseBody
    public RespResult getByIds(@RequestBody ReqBody<T> reqBody) {
        List<Serializable> ids = reqBody.getIds();
        Assert.assertNotEmpty(ids, (String)"ID\u6570\u7ec4[ids]");
        List<T> list = this.baseService.getByIds(ids);
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @RequestMapping(value={"/getByObj"})
    @ResponseBody
    public RespResult getByObj(@RequestBody ReqBody<T> reqBody) {
        T obj = reqBody.getObj();
        Assert.assertNotEmpty(obj, (String)"\u5b9e\u4f53[obj]");
        List<T> list = this.baseService.getByObj(obj);
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @RequestMapping(value={"/getByField"})
    @ResponseBody
    public RespResult getByField(@RequestBody ReqBody<T> reqBody) {
        String field = reqBody.getField();
        Object value = reqBody.getValue();
        Assert.assertNotEmpty((CharSequence)field, (String)"\u5b57\u6bb5[field]");
        Assert.assertNotEmpty((Object)value, (String)"\u503c[value]");
        List<T> list = this.baseService.getByField(field, value);
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @RequestMapping(value={"/getBatchByField"})
    @ResponseBody
    public RespResult getBatchByField(@RequestBody ReqBody<T> reqBody) {
        String field = reqBody.getField();
        List<Object> values = reqBody.getValues();
        Assert.assertNotEmpty((CharSequence)field, (String)"\u5b57\u6bb5[field]");
        Assert.assertNotEmpty(values, (String)"\u503c\u6570\u7ec4[values]");
        List<T> list = this.baseService.getBatchByField(field, values);
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @RequestMapping(value={"/getAll"})
    @ResponseBody
    public RespResult getAll() {
        List<T> list = this.baseService.getAll();
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", list);
    }

    @RequestMapping(value={"/customQuery"})
    @ResponseBody
    public RespResult customQuery(@RequestBody ReqBody<T> reqBody) {
        QueryBody<T> queryBody = reqBody.getQueryBody();
        Assert.assertNotEmpty(queryBody, (String)"\u67e5\u8be2\u7b56\u7565[queryBody]");
        queryBody.check();
        QueryWrapper<T> queryWrapper = queryBody.buildWrapper();
        IPage<T> page = queryBody.buildPage();
        try {
            if (Assert.notEmpty(page)) {
                IPage<T> wrapperPage = this.baseService.getByWrapperPage((Wrapper<T>)queryWrapper, page);
                ResultPage<T> resultPage = new ResultPage<T>(wrapperPage);
                return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", resultPage);
            }
            List<T> byWrapper = this.baseService.getByWrapper((Wrapper<T>)queryWrapper);
            return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", byWrapper);
        }
        catch (BadSqlGrammarException e) {
            throw new BusinessRunTimeException("\u67e5\u8be2\u5931\u8d25\uff1a{}", new Object[]{e.getMessage()});
        }
    }

    @RequestMapping(value={"/countByObj"})
    @ResponseBody
    public RespResult countByObj(@RequestBody ReqBody<T> reqBody) {
        T obj = reqBody.getObj();
        Assert.assertNotEmpty(obj, (String)"\u5b9e\u4f53[obj]");
        int count = this.baseService.countByObj(obj);
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", (Object)count);
    }

    @RequestMapping(value={"/countByField"})
    @ResponseBody
    public RespResult countByField(@RequestBody ReqBody<T> reqBody) {
        String field = reqBody.getField();
        Object value = reqBody.getValue();
        Assert.assertNotEmpty((CharSequence)field, (String)"\u5b57\u6bb5[field]");
        Assert.assertNotEmpty((Object)value, (String)"\u503c[value]");
        int count = this.baseService.countByField(field, value);
        return RespResult.success((String)"\u67e5\u8be2\u6210\u529f", (Object)count);
    }
}

