/*
 * Decompiled with CFR 0.152.
 */
package world.xuewei.fast.crud.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import world.xuewei.fast.core.util.Assert;
import world.xuewei.fast.crud.annotation.FastController;
import world.xuewei.fast.crud.controller.BaseController;
import world.xuewei.fast.crud.service.BaseDBService;

@Configuration
public class FastControllerRegister
implements ApplicationContextAware,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(FastControllerRegister.class);
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Bean
    public String registerFastController(RequestMappingHandlerMapping handlerMapping) {
        Map fastMap = this.context.getBeansWithAnnotation(FastController.class);
        for (String beanName : fastMap.keySet()) {
            Object fastController = fastMap.get(beanName);
            Class<?> fastClass = fastController.getClass();
            RequestMapping requestMappingAnnotation = fastClass.getAnnotation(RequestMapping.class);
            if (Assert.isEmpty((Object)requestMappingAnnotation)) {
                log.warn("FastController Must Be Tagged With @RequestMapping. {} Fail To Register", (Object)beanName);
                continue;
            }
            BaseDBService<Object> service = this.getService(fastClass, fastController);
            if (Assert.isEmpty(service)) {
                log.warn("FastController Must Inject A Member Variable Named 'service'. {} Fail To Register", (Object)beanName);
                continue;
            }
            Object[] annotations = requestMappingAnnotation.value();
            if (!Assert.notEmpty((Object[])annotations)) continue;
            RequestMappingInfo.BuilderConfiguration initConfig = this.initConfig(handlerMapping);
            for (Object annotation : annotations) {
                Method[] methods;
                BaseController<Object> baseController = new BaseController<Object>(service);
                for (Method method : methods = BaseController.class.getDeclaredMethods()) {
                    String methodName = method.getName();
                    String path = String.format("%s/%s", annotation, methodName);
                    handlerMapping.registerMapping(RequestMappingInfo.paths((String[])new String[]{path}).options(initConfig).build(), baseController, method);
                    log.info("FastController Interface Successfully Registered. Path {}", (Object)path);
                }
            }
        }
        return null;
    }

    private RequestMappingInfo.BuilderConfiguration initConfig(RequestMappingHandlerMapping handlerMapping) {
        RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();
        config.setTrailingSlashMatch(handlerMapping.useTrailingSlashMatch());
        config.setContentNegotiationManager(handlerMapping.getContentNegotiationManager());
        if (handlerMapping.getPatternParser() != null) {
            config.setPatternParser(handlerMapping.getPatternParser());
        } else {
            config.setSuffixPatternMatch(handlerMapping.useSuffixPatternMatch());
            config.setRegisteredSuffixPatternMatch(handlerMapping.useRegisteredSuffixPatternMatch());
            config.setPathMatcher(handlerMapping.getPathMatcher());
        }
        return config;
    }

    private BaseDBService<Object> getService(Class<?> fastClass, Object fastController) {
        Object serviceInstance;
        try {
            Field serviceField = fastClass.getDeclaredField("service");
            serviceField.setAccessible(true);
            serviceInstance = serviceField.get(fastController);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
        return Assert.notEmpty((Object)serviceInstance) ? (BaseDBService)serviceInstance : null;
    }
}

