/*
 * Decompiled with CFR 0.152.
 */
package world.komq.paralleluniverse.api.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import world.komq.paralleluniverse.api.DatabaseManager;
import world.komq.paralleluniverse.api.LoggerObject;
import world.komq.paralleluniverse.api.internal.DatabaseManagerImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018\u00b2\u0006\f\u0010\u0019\u001a\u0004\u0018\u00010\u0013X\u008a\u0084\u0002\u00b2\u0006\f\u0010\u001a\u001a\u0004\u0018\u00010\u0013X\u008a\u0084\u0002\u00b2\u0006\f\u0010\u001b\u001a\u0004\u0018\u00010\u0013X\u008a\u0084\u0002"}, d2={"Lworld/komq/paralleluniverse/api/internal/DatabaseManagerImpl;", "Lworld/komq/paralleluniverse/api/DatabaseManager;", "()V", "komworldDatabaseConf", "Ljava/io/File;", "komworldDbPassword", "", "komworldDbURL", "komworldDbUsername", "komworldDir", "kwDirFile", "boolToInt", "", "bool", "", "checkConfig", "commit", "", "getGameServerDatabase", "Lorg/jetbrains/exposed/sql/Database;", "getPlayerGameDatabase", "getUniversalDatabase", "intToBool", "integer", "parallel-universe-core", "gameServerDb", "universalDb", "playerGameDb"})
public final class DatabaseManagerImpl
implements DatabaseManager {
    @NotNull
    private final File kwDirFile = new File(Intrinsics.stringPlus((String)System.getProperty("user.home"), (Object)"/.komworld"));
    @NotNull
    private final File komworldDir;
    @NotNull
    private final File komworldDatabaseConf;
    @NotNull
    private String komworldDbURL;
    @NotNull
    private String komworldDbUsername;
    @NotNull
    private String komworldDbPassword;

    public DatabaseManagerImpl() {
        File file;
        if (!this.kwDirFile.exists()) {
            this.kwDirFile.mkdirs();
            file = this.kwDirFile;
        } else {
            file = this.kwDirFile;
        }
        this.komworldDir = file;
        this.komworldDatabaseConf = new File(this.komworldDir, "komworldDatabaseConf.txt");
        this.komworldDbURL = "";
        this.komworldDbUsername = "";
        this.komworldDbPassword = "";
    }

    private final boolean checkConfig() {
        boolean bl;
        if (!this.komworldDatabaseConf.exists()) {
            this.komworldDatabaseConf.createNewFile();
            LoggerObject.INSTANCE.getLogger().severe("[DatabaseManager] Credential Mismatch. Please edit komworldDatabaseConf.txt at \"" + this.komworldDir.getAbsolutePath() + "\".");
            LoggerObject.INSTANCE.getLogger().severe("Line 1: URL, Line 2: Username, Line 3: Password");
            bl = false;
        } else {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            List lines = FilesKt.readLines((File)this.komworldDatabaseConf, (Charset)charset);
            if (!((Collection)lines).isEmpty() && lines.size() == 3) {
                this.komworldDbURL = (String)lines.get(0);
                this.komworldDbUsername = (String)lines.get(1);
                this.komworldDbPassword = (String)lines.get(2);
            }
            bl = true;
        }
        boolean result = bl;
        return result;
    }

    @Nullable
    public Database getGameServerDatabase() {
        Database db2 = null;
        if (this.checkConfig()) {
            db2 = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)Intrinsics.stringPlus((String)(StringsKt.endsWith$default((String)this.komworldDbURL, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)this.komworldDbURL, (CharSequence)"/") : this.komworldDbURL), (Object)"GameServerData"), (String)"com.mysql.cj.jdbc.Driver", (String)this.komworldDbUsername, (String)this.komworldDbPassword, null, null, null, (int)112, null);
        }
        return db2;
    }

    @Nullable
    public Database getUniversalDatabase() {
        Database db2 = null;
        if (this.checkConfig()) {
            db2 = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)Intrinsics.stringPlus((String)(StringsKt.endsWith$default((String)this.komworldDbURL, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)this.komworldDbURL, (CharSequence)"/") : this.komworldDbURL), (Object)"UniversalData"), (String)"com.mysql.cj.jdbc.Driver", (String)this.komworldDbUsername, (String)this.komworldDbPassword, null, null, null, (int)112, null);
        }
        return db2;
    }

    @Nullable
    public Database getPlayerGameDatabase() {
        Database db2 = null;
        if (this.checkConfig()) {
            db2 = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)Intrinsics.stringPlus((String)(StringsKt.endsWith$default((String)this.komworldDbURL, (String)"/", (boolean)false, (int)2, null) ? StringsKt.removePrefix((String)this.komworldDbURL, (CharSequence)"/") : this.komworldDbURL), (Object)"PlayerGameData"), (String)"com.mysql.cj.jdbc.Driver", (String)this.komworldDbUsername, (String)this.komworldDbPassword, null, null, null, (int)112, null);
        }
        return db2;
    }

    public int boolToInt(boolean bool) {
        int n;
        boolean bl = bool;
        if (bl) {
            n = 1;
        } else if (!bl) {
            n = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public boolean intToBool(int integer) {
        boolean bl;
        switch (integer) {
            case 1: {
                bl = true;
                break;
            }
            case 0: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void commit() {
        Lazy gameServerDb$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Database>(this){
            final /* synthetic */ DatabaseManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Database invoke() {
                return this.this$0.getGameServerDatabase();
            }
        }));
        Lazy universalDb$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Database>(this){
            final /* synthetic */ DatabaseManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Database invoke() {
                return this.this$0.getUniversalDatabase();
            }
        }));
        Lazy playerGameDb$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Database>(this){
            final /* synthetic */ DatabaseManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Database invoke() {
                return this.this$0.getPlayerGameDatabase();
            }
        }));
        if (DatabaseManagerImpl.commit$lambda-0((Lazy<Database>)gameServerDb$delegate) != null) {
            ThreadLocalTransactionManagerKt.transaction((Database)DatabaseManagerImpl.commit$lambda-0((Lazy<Database>)gameServerDb$delegate), (Function1)commit.1.INSTANCE);
        } else {
            LoggerObject.INSTANCE.getLogger().severe("[DatabaseManager] GameServerData \ub370\uc774\ud130\ubca0\uc774\uc2a4\ub97c \uac00\uc838 \uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (DatabaseManagerImpl.commit$lambda-1((Lazy<Database>)universalDb$delegate) != null) {
            ThreadLocalTransactionManagerKt.transaction((Database)DatabaseManagerImpl.commit$lambda-1((Lazy<Database>)universalDb$delegate), (Function1)commit.2.INSTANCE);
        } else {
            LoggerObject.INSTANCE.getLogger().severe("[DatabaseManager] UniversalData \ub370\uc774\ud130\ubca0\uc774\uc2a4\ub97c \uac00\uc838 \uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (DatabaseManagerImpl.commit$lambda-2((Lazy<Database>)playerGameDb$delegate) != null) {
            ThreadLocalTransactionManagerKt.transaction((Database)DatabaseManagerImpl.commit$lambda-2((Lazy<Database>)playerGameDb$delegate), (Function1)commit.3.INSTANCE);
        } else {
            LoggerObject.INSTANCE.getLogger().severe("[DatabaseManager] PlayerGameData \ub370\uc774\ud130\ubca0\uc774\uc2a4\ub97c \uac00\uc838 \uc62c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
    }

    private static final Database commit$lambda-0(Lazy<Database> $gameServerDb$delegate) {
        Lazy<Database> lazy = $gameServerDb$delegate;
        return (Database)lazy.getValue();
    }

    private static final Database commit$lambda-1(Lazy<Database> $universalDb$delegate) {
        Lazy<Database> lazy = $universalDb$delegate;
        return (Database)lazy.getValue();
    }

    private static final Database commit$lambda-2(Lazy<Database> $playerGameDb$delegate) {
        Lazy<Database> lazy = $playerGameDb$delegate;
        return (Database)lazy.getValue();
    }
}

