/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Optional;
import javax.annotation.Nullable;
import world.data.jdbc.model.Literal;
import world.data.jdbc.vocab.Xsd;

public final class LiteralFactory {
    public static final Literal TRUE = new Literal("true", Xsd.BOOLEAN);
    public static final Literal FALSE = new Literal("false", Xsd.BOOLEAN);

    public static Literal createString(String string) {
        return new Literal(string, Xsd.STRING);
    }

    public static Literal createString(String string, @Nullable String lang) {
        return new Literal(string, Xsd.STRING, lang);
    }

    public static Literal createBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Literal createByte(byte value) {
        return new Literal(Byte.toString(value), Xsd.BYTE);
    }

    public static Literal createShort(short value) {
        return new Literal(Short.toString(value), Xsd.SHORT);
    }

    public static Literal createInt(int value) {
        return new Literal(Integer.toString(value), Xsd.INT);
    }

    public static Literal createLong(long value) {
        return new Literal(Long.toString(value), Xsd.LONG);
    }

    public static Literal createInteger(long value) {
        return new Literal(Long.toString(value), Xsd.INTEGER);
    }

    public static Literal createInteger(BigInteger value) {
        return new Literal(value.toString(), Xsd.INTEGER);
    }

    public static Literal createFloat(float value) {
        return new Literal(!Float.isInfinite(value) ? Float.toString(value) : (value > 0.0f ? "INF" : "-INF"), Xsd.FLOAT);
    }

    public static Literal createDouble(double value) {
        return new Literal(!Double.isInfinite(value) ? Double.toString(value) : (value > 0.0 ? "INF" : "-INF"), Xsd.DOUBLE);
    }

    public static Literal createDecimal(double value) {
        return LiteralFactory.createDecimal(BigDecimal.valueOf(value));
    }

    public static Literal createDecimal(BigDecimal value) {
        return new Literal(value.toPlainString(), Xsd.DECIMAL);
    }

    public static Literal createYearMonthDuration(Period value) {
        if (value.getDays() != 0) {
            throw new IllegalArgumentException("Year month duration may not contain days: " + value);
        }
        return new Literal(value.toString(), Xsd.YEARMONTHDURATION);
    }

    public static Literal createDayTimeDuration(Duration value) {
        return new Literal(value.toString(), Xsd.DAYTIMEDURATION);
    }

    public static Literal createYearMonth(TemporalAccessor value) {
        return LiteralFactory.createYearMonth(YearMonth.from(LiteralFactory.toUtcDateTime(value).orElse(value)));
    }

    public static Literal createYearMonth(YearMonth value) {
        return new Literal(value.toString(), Xsd.GYEARMONTH);
    }

    public static Literal createMonthDay(TemporalAccessor value) {
        return LiteralFactory.createMonthDay(MonthDay.from(LiteralFactory.toUtcDateTime(value).orElse(value)));
    }

    public static Literal createMonthDay(MonthDay value) {
        return new Literal(value.toString(), Xsd.GMONTHDAY);
    }

    public static Literal createYear(TemporalAccessor value) {
        return LiteralFactory.createYear(Year.from(LiteralFactory.toUtcDateTime(value).orElse(value)));
    }

    public static Literal createYear(Year value) {
        return new Literal(value.toString(), Xsd.GYEAR);
    }

    public static Literal createMonth(TemporalAccessor value) {
        return LiteralFactory.createMonth(Month.from(LiteralFactory.toUtcDateTime(value).orElse(value)));
    }

    public static Literal createMonth(Month value) {
        return new Literal("--" + value.getValue(), Xsd.GMONTH);
    }

    public static Literal createDay(TemporalAccessor value) {
        return LiteralFactory.createDay(LiteralFactory.toUtcDateTime(value).orElse(value).get(ChronoField.DAY_OF_MONTH));
    }

    public static Literal createDay(int dayOfMonth) {
        ChronoField.DAY_OF_MONTH.checkValidIntValue(dayOfMonth);
        return new Literal("---" + dayOfMonth, Xsd.GDAY);
    }

    public static Literal createDate(TemporalAccessor value) {
        return LiteralFactory.createDate(LocalDate.from(LiteralFactory.toUtcDateTime(value).orElse(value)));
    }

    public static Literal createDate(LocalDate value) {
        return new Literal(DateTimeFormatter.ISO_LOCAL_DATE.format(value), Xsd.DATE);
    }

    public static Literal createDateTime(TemporalAccessor value) {
        return LiteralFactory.toUtcDateTime(value).map(t -> LiteralFactory.createDateTime(OffsetDateTime.from(t))).orElseGet(() -> LiteralFactory.createDateTime(LocalDateTime.from(value)));
    }

    public static Literal createDateTime(OffsetDateTime value) {
        value = value.withOffsetSameInstant(ZoneOffset.UTC);
        return new Literal(LiteralFactory.trimZeros(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value)), Xsd.DATETIME);
    }

    public static Literal createDateTime(LocalDateTime value) {
        return new Literal(LiteralFactory.trimZeros(DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value)), Xsd.DATETIME);
    }

    public static Literal createTime(TemporalAccessor value) {
        return LiteralFactory.toUtcTime(value).map(t -> LiteralFactory.createTime(OffsetTime.from(t))).orElseGet(() -> LiteralFactory.createTime(LocalTime.from(value)));
    }

    public static Literal createTime(OffsetTime value) {
        value = value.withOffsetSameInstant(ZoneOffset.UTC);
        return new Literal(LiteralFactory.trimZeros(DateTimeFormatter.ISO_OFFSET_TIME.format(value)), Xsd.TIME);
    }

    public static Literal createTime(LocalTime value) {
        return new Literal(LiteralFactory.trimZeros(DateTimeFormatter.ISO_LOCAL_TIME.format(value)), Xsd.TIME);
    }

    private static Optional<TemporalAccessor> toUtcDateTime(TemporalAccessor value) {
        if (value.isSupported(ChronoField.OFFSET_SECONDS)) {
            return Optional.of(OffsetDateTime.from(value).withOffsetSameInstant(ZoneOffset.UTC));
        }
        if (value.isSupported(ChronoField.INSTANT_SECONDS)) {
            return Optional.of(Instant.from(value).atOffset(ZoneOffset.UTC));
        }
        return Optional.empty();
    }

    private static Optional<TemporalAccessor> toUtcTime(TemporalAccessor value) {
        if (value.isSupported(ChronoField.OFFSET_SECONDS)) {
            return Optional.of(OffsetTime.from(value).withOffsetSameInstant(ZoneOffset.UTC));
        }
        if (value.isSupported(ChronoField.INSTANT_SECONDS)) {
            return Optional.of(Instant.from(value).atOffset(ZoneOffset.UTC).toOffsetTime());
        }
        return Optional.empty();
    }

    @Deprecated
    public static Literal createDate(java.util.Date value) {
        return LiteralFactory.createDate(value.toInstant());
    }

    @Deprecated
    public static Literal createDate(Date value) {
        return LiteralFactory.createDate(value.toLocalDate());
    }

    @Deprecated
    public static Literal createDate(Date value, Calendar calendar) {
        return LiteralFactory.createDate(LiteralFactory.toInstantUsingCalendar(value, calendar));
    }

    public static Literal createDateTime(java.util.Date value) {
        return LiteralFactory.createDateTime(value.toInstant());
    }

    @Deprecated
    public static Literal createDateTime(Timestamp value) {
        return LiteralFactory.createDateTime(value.toLocalDateTime());
    }

    @Deprecated
    public static Literal createDateTime(Timestamp value, Calendar calendar) {
        return LiteralFactory.createDateTime(LiteralFactory.toInstantUsingCalendar(value, calendar));
    }

    @Deprecated
    public static Literal createTime(Time value) {
        return LiteralFactory.createTime(value.toLocalTime().withNano((int)(value.getTime() % 1000L) * 1000000));
    }

    @Deprecated
    public static Literal createTime(Time value, Calendar calendar) {
        return LiteralFactory.createTime(LiteralFactory.toInstantUsingCalendar(value, calendar));
    }

    private static Instant toInstantUsingCalendar(java.util.Date value, Calendar calendar) {
        calendar.setTime(value);
        return calendar.toInstant();
    }

    private static String trimZeros(String string) {
        int end;
        int sig;
        boolean utc = string.endsWith("Z");
        for (sig = end = string.length() - 1 - (utc ? 1 : 0); sig >= 0 && string.charAt(sig) == '0'; --sig) {
        }
        if (sig == end) {
            return string;
        }
        for (int dec = sig; dec >= 0; --dec) {
            char ch = string.charAt(dec);
            if (ch == '.') {
                int stop = dec == sig ? sig : sig + 1;
                StringBuilder buf = new StringBuilder(stop + (utc ? 1 : 0));
                buf.append(string, 0, stop);
                if (utc) {
                    buf.append('Z');
                }
                return buf.toString();
            }
            if (ch < '0' || ch > '9') break;
        }
        return string;
    }

    private LiteralFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

