/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.model;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import world.data.jdbc.internal.types.NTriplesFormat;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Xsd;

public final class Literal
implements Node {
    @Nonnull
    private final String lexicalForm;
    @Nonnull
    private final Iri datatype;
    private final String language;

    public Literal(String lexicalForm, Iri datatype) {
        this(lexicalForm, datatype, null);
    }

    public Literal(String lexicalForm, Iri datatype, @Nullable String language) {
        this.lexicalForm = Objects.requireNonNull(lexicalForm, "lexicalForm");
        this.datatype = Objects.requireNonNull(datatype, "datatype");
        this.language = language;
        if (language != null) {
            if (!NTriplesFormat.isWellFormedLanguage(language)) {
                throw new IllegalArgumentException("Invalid language tag: " + language);
            }
            if (!Xsd.STRING.equals(datatype)) {
                throw new IllegalArgumentException("Language tag with datatype other than xsd:string: " + datatype);
            }
        }
    }

    @Override
    public String toString() {
        return NTriplesFormat.formatLiteral(this.lexicalForm, this.datatype, this.language);
    }

    @Nonnull
    public String getLexicalForm() {
        return this.lexicalForm;
    }

    @Nonnull
    public Iri getDatatype() {
        return this.datatype;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)o;
        String this$lexicalForm = this.getLexicalForm();
        String other$lexicalForm = other.getLexicalForm();
        if (this$lexicalForm == null ? other$lexicalForm != null : !this$lexicalForm.equals(other$lexicalForm)) {
            return false;
        }
        Iri this$datatype = this.getDatatype();
        Iri other$datatype = other.getDatatype();
        if (this$datatype == null ? other$datatype != null : !((Object)this$datatype).equals(other$datatype)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $lexicalForm = this.getLexicalForm();
        result = result * 59 + ($lexicalForm == null ? 43 : $lexicalForm.hashCode());
        Iri $datatype = this.getDatatype();
        result = result * 59 + ($datatype == null ? 43 : ((Object)$datatype).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }
}

