/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.model;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import world.data.jdbc.internal.types.NTriplesFormat;
import world.data.jdbc.model.Node;

public final class Iri
implements Node {
    private final String iri;

    public Iri(URI uri) {
        this(uri.toString());
    }

    public Iri(URL url) {
        this(url.toString());
    }

    public Iri(String iri) {
        this.iri = Objects.requireNonNull(iri, "iri");
    }

    public URI toURI() {
        return URI.create(this.iri);
    }

    public URL toURL() throws MalformedURLException {
        return this.toURI().toURL();
    }

    @Override
    public String toString() {
        return NTriplesFormat.formatIri(this.iri);
    }

    public String getIri() {
        return this.iri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Iri)) {
            return false;
        }
        Iri other = (Iri)o;
        String this$iri = this.getIri();
        String other$iri = other.getIri();
        return !(this$iri == null ? other$iri != null : !this$iri.equals(other$iri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $iri = this.getIri();
        result = result * 59 + ($iri == null ? 43 : $iri.hashCode());
        return result;
    }
}

