/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.sql.SQLWarning;
import java.util.logging.Logger;

public class WarningList {
    private static final Logger log = Logger.getLogger(WarningList.class.getName());
    private SQLWarning head;
    private SQLWarning tail;

    public synchronized SQLWarning get() {
        return this.head;
    }

    public void add(String warning) {
        this.add(new SQLWarning(warning));
    }

    public synchronized void add(SQLWarning warning) {
        log.warning("SQL Warning was issued: " + warning);
        if (this.head == null) {
            this.head = warning;
        } else {
            this.tail.setNextWarning(warning);
        }
        this.tail = warning;
    }

    public synchronized void clear() {
        this.tail = null;
        this.head = null;
    }
}

