/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import world.data.jdbc.Driver;

public final class Versions {
    private static final Logger log = Logger.getLogger(Versions.class.getName());

    public static String findVersionString() {
        String resourceName = "META-INF/maven/world.data/dw-jdbc/pom.properties";
        URL resourceUrl = Driver.class.getClassLoader().getResource(resourceName);
        if (resourceUrl == null) {
            log.info("Unable to find JDBC driver version via resource: " + resourceName);
            return "0.0-UNKNOWN";
        }
        Properties props = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(resourceUrl.openStream());){
            props.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse resource: " + resourceName, e);
        }
        String version = props.getProperty("version");
        if (version == null) {
            throw new IllegalStateException("Unable find 'version' property in resource: " + resourceName);
        }
        return version;
    }

    public static int[] parseVersionNumbers(String version) {
        String versionNumbers = version.replaceFirst("^([0-9.]+).*", "$1");
        int[] versions = Arrays.stream(versionNumbers.split("\\.")).mapToInt(Integer::parseInt).toArray();
        if (versions.length < 2) {
            throw new IllegalStateException("Expected version number to contain at least <major>.<minor>.");
        }
        return versions;
    }
}

