/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;

public class ResourceManager
implements AutoCloseable {
    private final Set<AutoCloseable> resources = Collections.newSetFromMap(new WeakHashMap());

    public synchronized void register(AutoCloseable closeable) {
        this.resources.add(closeable);
    }

    public synchronized void remove(AutoCloseable closeable) {
        this.resources.remove(closeable);
    }

    private synchronized List<AutoCloseable> snapshot() {
        return new ArrayList<AutoCloseable>(this.resources);
    }

    @Override
    public void close() throws Exception {
        List<AutoCloseable> closeables = this.snapshot();
        Exception firstException = null;
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

