/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import world.data.jdbc.internal.util.Conditions;

public final class LimitedIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private int remaining;

    public LimitedIterator(Iterator<T> delegate, int max) throws SQLException {
        Conditions.check(max >= 0, "max must be non-negative");
        this.delegate = delegate;
        this.remaining = max;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0 && this.delegate.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        --this.remaining;
        return this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

