/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import world.data.jdbc.internal.transport.FieldParser;
import world.data.jdbc.internal.transport.ParserUtil;
import world.data.jdbc.internal.transport.Response;
import world.data.jdbc.model.Blank;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Literal;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Xsd;

final class NodeParser {
    private final JsonParser parser;
    private final boolean rdf;
    private boolean nonEmpty;
    private String type;
    private Iri datatype;
    private String value;
    private String language;

    static NodeParser forSparqlResults(JsonParser parser) {
        return new NodeParser(parser, false);
    }

    static NodeParser forRdf(JsonParser parser) {
        return new NodeParser(parser, true);
    }

    private NodeParser(JsonParser parser, boolean rdf) {
        this.parser = Objects.requireNonNull(parser, "parser");
        this.rdf = rdf;
    }

    @Nullable
    Node[] parseRow(Map<String, Response.Column> columnsByVar) throws IOException {
        Node[] nodes = new Node[columnsByVar.size()];
        this.nonEmpty = false;
        FieldParser.parseObject(this.parser, (field, token) -> {
            Response.Column column = (Response.Column)columnsByVar.get(field);
            if (column != null && token == JsonToken.START_OBJECT) {
                Node node;
                nodes[column.getIndex()] = node = this.parse();
                this.nonEmpty |= node != null;
            }
        });
        return this.nonEmpty ? nodes : null;
    }

    @Nullable
    Node parse() throws IOException {
        this.language = null;
        this.value = null;
        this.type = null;
        this.datatype = Xsd.STRING;
        FieldParser.parseObject(this.parser, (field, token) -> {
            switch (field) {
                case "type": {
                    ParserUtil.expect(this.parser, token, JsonToken.VALUE_STRING);
                    this.type = this.parser.getText();
                    break;
                }
                case "value": {
                    ParserUtil.expect(this.parser, token, JsonToken.VALUE_STRING);
                    this.value = this.parser.getText();
                    break;
                }
                case "datatype": {
                    ParserUtil.expect(this.parser, token, JsonToken.VALUE_STRING);
                    this.datatype = new Iri(this.parser.getText().intern());
                    break;
                }
                case "lang": 
                case "xml:lang": {
                    ParserUtil.expect(this.parser, token, JsonToken.VALUE_STRING);
                    this.language = this.parser.getText().intern();
                }
            }
        });
        switch (ParserUtil.require(this.parser, this.type, "type")) {
            case "uri": {
                return new Iri(ParserUtil.require(this.parser, this.value, "value"));
            }
            case "literal": 
            case "typed-literal": {
                return new Literal(ParserUtil.require(this.parser, this.value, "value"), this.datatype, this.language);
            }
            case "bnode": {
                return new Blank(this.stripBlankPrefix(ParserUtil.require(this.parser, this.value, "value")));
            }
        }
        return null;
    }

    private String stripBlankPrefix(String id) {
        return this.rdf && id.startsWith("_:") ? id.substring(2) : id;
    }
}

