/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.query;

import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.DataWorldStatement;
import world.data.jdbc.JdbcCompatibility;
import world.data.jdbc.internal.metadata.ColumnFactory;
import world.data.jdbc.internal.metadata.ColumnInfo;
import world.data.jdbc.internal.metadata.ParameterMetaDataImpl;
import world.data.jdbc.internal.metadata.ResultSetMetaDataImpl;
import world.data.jdbc.internal.metadata.SparqlDatabaseMetaData;
import world.data.jdbc.internal.query.QueryEngine;
import world.data.jdbc.internal.results.ResultSetImpl;
import world.data.jdbc.internal.transport.QueryApi;
import world.data.jdbc.internal.transport.Response;
import world.data.jdbc.internal.types.TypeMap;
import world.data.jdbc.internal.util.CloseableRef;
import world.data.jdbc.internal.util.Conditions;
import world.data.jdbc.internal.util.PeekingIterator;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Literal;
import world.data.jdbc.model.LiteralFactory;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Rdfs;
import world.data.jdbc.vocab.Xsd;

public final class SparqlEngine
implements QueryEngine {
    private final QueryApi queryApi;
    private final String catalog;
    private final String schema;

    public SparqlEngine(QueryApi queryApi, String catalog, String schema) {
        this.queryApi = Objects.requireNonNull(queryApi, "queryApi");
        this.catalog = Objects.requireNonNull(catalog, "catalog");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getLanguage() {
        return "sparql";
    }

    @Override
    public JdbcCompatibility getDefaultCompatibilityLevel() {
        return JdbcCompatibility.MEDIUM;
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData(DataWorldConnection connection) throws SQLException {
        return new SparqlDatabaseMetaData(connection, this.catalog, this.schema);
    }

    @Override
    public ParameterMetaData getParameterMetaData(String query) throws SQLException {
        int count = 0;
        int i = -1;
        while ((i = query.indexOf(63, i + 1)) != -1) {
            ++count;
        }
        return new ParameterMetaDataImpl(count);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet execute(DataWorldStatement statement, String query, Map<String, Node> parameters, Integer timeoutSeconds) throws SQLException {
        Integer maxRowsToReturn = statement.getMaxRows() != 0 ? Integer.valueOf(statement.getMaxRows()) : null;
        Response response = this.queryApi.executeQuery(query, parameters, maxRowsToReturn, timeoutSeconds);
        try (CloseableRef cleanup = new CloseableRef(response.getCleanup());){
            Boolean booleanResult = response.getBooleanResult();
            if (booleanResult != null) {
                ResultSet resultSet = this.createAskResultSet(statement, booleanResult);
                return resultSet;
            }
            Conditions.check(response.getRows() != null, "SQL response is missing row data");
            List<Response.Column> columns = response.getColumns();
            PeekingIterator<Node[]> rows = new PeekingIterator<Node[]>(response.getRows());
            Node[] firstRow = rows.peek();
            JdbcCompatibility level = statement.getJdbcCompatibilityLevel();
            List<ColumnInfo> columnInfos = this.buildColumnsMetadata(columns, level, firstRow);
            ResultSetMetaDataImpl metaData = new ResultSetMetaDataImpl(columnInfos);
            ResultSetImpl resultSet = new ResultSetImpl(statement, metaData, rows, response.getCleanup());
            ResultSet resultSet2 = cleanup.detach(resultSet);
            return resultSet2;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unexpected exception parsing SPARQL response from server.", e);
        }
    }

    private ResultSet createAskResultSet(DataWorldStatement statement, boolean askResult) throws SQLException {
        ColumnInfo singleColumn = ColumnFactory.builder("ASK", Xsd.BOOLEAN).nullable(0).build();
        List<Node[]> singleRow = Collections.singletonList(new Node[]{LiteralFactory.createBoolean(askResult)});
        return new ResultSetImpl(statement, new ResultSetMetaDataImpl(singleColumn), singleRow);
    }

    private List<ColumnInfo> buildColumnsMetadata(List<Response.Column> columns, JdbcCompatibility level, Node[] firstRow) {
        ArrayList<ColumnInfo> columnsMetaData = new ArrayList<ColumnInfo>();
        for (int i = 0; i < columns.size(); ++i) {
            Response.Column column = columns.get(i);
            Node sampleValue = firstRow != null ? firstRow[i] : null;
            columnsMetaData.add(this.buildColumnMetadata(column, level, sampleValue));
        }
        return columnsMetaData;
    }

    private ColumnInfo buildColumnMetadata(Response.Column column, JdbcCompatibility level, Node sampleValue) {
        Iri datatype = this.pickType(level, sampleValue);
        return ColumnFactory.builder(column.getName(), datatype).catalogName(this.catalog).schemaName(this.schema).tableName("RDF").build();
    }

    private Iri pickType(JdbcCompatibility level, Node sampleValue) {
        switch (level) {
            case LOW: {
                return TypeMap.DATATYPE_RAW_NODE;
            }
            case MEDIUM: {
                return Xsd.STRING;
            }
        }
        if (sampleValue == null) {
            return Xsd.STRING;
        }
        if (sampleValue instanceof Literal) {
            return ((Literal)sampleValue).getDatatype();
        }
        return Rdfs.RESOURCE;
    }

    @Override
    public void checkPositionalParametersSupported() throws SQLException {
        throw new SQLFeatureNotSupportedException("Positional parameters are not supported with Sparql.");
    }

    @Override
    public void checkNamedParametersSupported() throws SQLException {
    }
}

