/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.DataWorldPreparedStatement;
import world.data.jdbc.internal.metadata.AbstractDatabaseMetaData;
import world.data.jdbc.internal.metadata.MetaDataSchema;
import world.data.jdbc.internal.types.TypeMap;
import world.data.jdbc.internal.types.TypeMapping;
import world.data.jdbc.internal.util.Optionals;
import world.data.jdbc.model.Iri;
import world.data.jdbc.vocab.Xsd;

public final class SqlDatabaseMetaData
extends AbstractDatabaseMetaData {
    public SqlDatabaseMetaData(DataWorldConnection connection, String catalog, String schema) {
        super(connection, catalog, schema);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        try (DataWorldPreparedStatement statement = this.connection.prepareStatement("SELECT DISTINCT owner FROM Schemata ORDER BY owner");){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String owner = resultSet.getString("owner");
                rows.add(new Object[]{owner});
            }
        }
        return MetaDataSchema.newResultSet(MetaDataSchema.CATALOG_COLUMNS, rows);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        try (DataWorldPreparedStatement statement = this.connection.prepareStatement("SELECT * FROM TableColumns WHERE owner = COALESCE(?,owner) AND dataset LIKE ? AND tableName LIKE ? AND columnName LIKE ? ORDER BY owner, dataset, tableName, columnIndex");){
            int index = 0;
            statement.setString(++index, catalog);
            statement.setString(++index, Optionals.or(schemaPattern, "%"));
            statement.setString(++index, Optionals.or(tableNamePattern, "%"));
            statement.setString(++index, Optionals.or(columnNamePattern, "%"));
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String owner = resultSet.getString("owner");
                String dataset = resultSet.getString("dataset");
                String tableName = resultSet.getString("tableName");
                int columnIndex = resultSet.getInt("columnIndex");
                String columnName = resultSet.getString("columnName");
                Iri datatype = Optionals.mapIfPresent(resultSet.getString("columnDatatype"), Iri::new);
                Boolean nullable = resultSet.getObject("columnNullable", Boolean.class);
                TypeMapping mapping = TypeMap.INSTANCE.getStandardOrCustom(datatype);
                rows.add(new Object[]{owner, dataset, tableName, columnName, mapping.getJdbcType().getVendorTypeNumber(), mapping.getDatatype(), mapping.getPrecision(), null, mapping.getMaxScale(), 10, nullable == null ? 2 : (nullable != false ? 1 : 0), null, null, null, null, Xsd.STRING.equals(mapping.getDatatype()) ? Integer.valueOf(Integer.MAX_VALUE) : null, columnIndex, nullable == null ? "" : (nullable != false ? "YES" : "NO"), null, null, null, null, "NO"});
            }
        }
        return MetaDataSchema.newResultSet(MetaDataSchema.COLUMN_COLUMNS, rows);
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    String getLiteralQuoteString() {
        return "'";
    }

    @Override
    public String getNumericFunctions() {
        return String.join((CharSequence)",", "ABS", "CEIL", "FLOOR", "ROUND");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        try (DataWorldPreparedStatement statement = this.connection.prepareStatement("SELECT DISTINCT owner, dataset FROM Schemata WHERE owner = COALESCE(?,owner) AND dataset LIKE ? ORDER BY owner, dataset");){
            int index = 0;
            statement.setString(++index, catalog);
            statement.setString(++index, Optionals.or(schemaPattern, "%"));
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String owner = resultSet.getString("owner");
                String dataset = resultSet.getString("dataset");
                rows.add(new Object[]{dataset, owner});
            }
        }
        return MetaDataSchema.newResultSet(MetaDataSchema.SCHEMA_COLUMNS, rows);
    }

    @Override
    public String getSQLKeywords() {
        return String.join((CharSequence)",", "AND", "AS", "ASC", "BY", "CAST", "DESC", "DISTINCT", "FROM", "FULL", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "JOIN", "LEFT", "LIKE", "LIMIT", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "OR", "ORDER", "OUTER", "RIGHT", "SELECT", "UNION", "USING", "WHERE");
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getStringFunctions() {
        return String.join((CharSequence)",", "CONCAT", "LENGTH", "LENGTH", "LOWER", "REGEX", "REPLACE", "SUBSTRING", "UPPER");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        Object[][] rows = new Object[][]{{"TABLE"}};
        return MetaDataSchema.newResultSet(MetaDataSchema.TABLE_TYPE_COLUMNS, rows);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (Optionals.nullOrContains(types, "TABLE")) {
            try (DataWorldPreparedStatement statement = this.connection.prepareStatement("SELECT DISTINCT owner, dataset, tableName FROM Tables WHERE owner = COALESCE(?,owner) AND dataset LIKE ? AND tableName LIKE ? ORDER BY owner, dataset, tableName");){
                int index = 0;
                statement.setString(++index, catalog);
                statement.setString(++index, Optionals.or(schemaPattern, "%"));
                statement.setString(++index, Optionals.or(tableNamePattern, "%"));
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String owner = resultSet.getString("owner");
                    String dataset = resultSet.getString("dataset");
                    String tableName = resultSet.getString("tableName");
                    rows.add(new Object[]{owner, dataset, tableName, "TABLE", "", null, null, null, null, null});
                }
            }
        }
        return MetaDataSchema.newResultSet(MetaDataSchema.TABLE_COLUMNS, rows);
    }

    @Override
    public String getTimeDateFunctions() {
        return String.join((CharSequence)",", "DAY", "HOURS", "MINUTES", "MONTH", "NOW", "SECONDS", "YEAR");
    }

    @Override
    public String getURL() throws SQLException {
        return "jdbc:data:world:sql:" + this.catalog + ":" + this.schema;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }
}

