/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import world.data.jdbc.internal.metadata.ColumnFactory;
import world.data.jdbc.internal.metadata.ColumnInfo;
import world.data.jdbc.internal.metadata.ResultSetMetaDataImpl;
import world.data.jdbc.internal.results.ResultSetImpl;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.LiteralFactory;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Xsd;

final class MetaDataSchema {
    static final ColumnInfo[] ATTRIBUTE_COLUMNS;
    static final ColumnInfo[] BEST_ROW_IDENTIFIER_COLUMNS;
    static final ColumnInfo[] CATALOG_COLUMNS;
    static final ColumnInfo[] CLIENT_INFO_PROPERTY_COLUMNS;
    static final ColumnInfo[] COLUMN_COLUMNS;
    static final ColumnInfo[] COLUMN_PRIVILEGE_COLUMNS;
    static final ColumnInfo[] CROSS_REFERENCE_COLUMNS;
    static final ColumnInfo[] EXPORTED_KEY_COLUMNS;
    static final ColumnInfo[] FUNCTION_COLUMN_COLUMNS;
    static final ColumnInfo[] FUNCTION_COLUMNS;
    static final ColumnInfo[] IMPORTED_KEY_COLUMNS;
    static final ColumnInfo[] INDEX_INFO_COLUMNS;
    static final ColumnInfo[] PRIMARY_KEY_COLUMNS;
    static final ColumnInfo[] PROCEDURE_COLUMN_COLUMNS;
    static final ColumnInfo[] PROCEDURE_COLUMNS;
    static final ColumnInfo[] PSUEDO_COLUMN_COLUMNS;
    static final ColumnInfo[] SCHEMA_COLUMNS;
    static final ColumnInfo[] SUPER_TABLE_COLUMNS;
    static final ColumnInfo[] SUPER_TYPE_COLUMNS;
    static final ColumnInfo[] TABLE_PRIVILEGE_COLUMNS;
    static final ColumnInfo[] TABLE_TYPE_COLUMNS;
    static final ColumnInfo[] TABLE_COLUMNS;
    static final ColumnInfo[] TYPE_INFO_COLUMNS;
    static final ColumnInfo[] UDT_COLUMNS;
    static final ColumnInfo[] VERSION_COLUMNS;

    static ResultSet newResultSet(ColumnInfo[] columns, Object[] ... rows) throws SQLException {
        return MetaDataSchema.newResultSet(columns, Arrays.asList(rows));
    }

    static ResultSet newResultSet(ColumnInfo[] columns, List<Object[]> rows) throws SQLException {
        Node[][] nodes = new Node[rows.size()][columns.length];
        for (int i = 0; i < nodes.length; ++i) {
            Object[] row = rows.get(i);
            for (int j = 0; j < columns.length; ++j) {
                nodes[i][j] = MetaDataSchema.toNode(row[j], columns[j].getType());
            }
        }
        return new ResultSetImpl(null, new ResultSetMetaDataImpl(columns), Arrays.asList(nodes));
    }

    private static Node toNode(Object obj, int type) {
        if (obj == null) {
            return null;
        }
        switch (type) {
            case -9: {
                String string = obj instanceof Iri ? ((Iri)obj).getIri() : (String)obj;
                return LiteralFactory.createString(string);
            }
            case 16: {
                return LiteralFactory.createBoolean((Boolean)obj);
            }
            case 5: {
                return LiteralFactory.createShort(((Number)obj).shortValue());
            }
            case 4: {
                return LiteralFactory.createInt(((Number)obj).intValue());
            }
        }
        throw new UnsupportedOperationException("Unexpected metadata value type: " + type);
    }

    private MetaDataSchema() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ColumnInfo empty = ColumnFactory.builder("", Xsd.STRING).nullable(1).build();
        ColumnInfo typeCat = ColumnFactory.builder("TYPE_CATA", Xsd.STRING).nullable(1).build();
        ColumnInfo typeSchema = ColumnFactory.builder("TYPE_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo typeName = ColumnFactory.builder("TYPE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo attrName = ColumnFactory.builder("ATTR_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo dataType = ColumnFactory.builder("DATA_TYPE", Xsd.INT).nullable(0).build();
        ColumnInfo attrTypeName = ColumnFactory.builder("ATTR_TYPE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo attrSize = ColumnFactory.builder("ATTR_SIZE", Xsd.INT).nullable(0).build();
        ColumnInfo decimalDigits = ColumnFactory.builder("DECIMAL_DIGITS", Xsd.INT).nullable(0).build();
        ColumnInfo numPrecRadix = ColumnFactory.builder("NUM_PREC_RADIX", Xsd.INT).nullable(0).build();
        ColumnInfo nullable = ColumnFactory.builder("NULLABLE", Xsd.INT).nullable(0).build();
        ColumnInfo shortNullable = ColumnFactory.builder("NULLABLE", Xsd.SHORT).nullable(0).build();
        ColumnInfo remarks = ColumnFactory.builder("REMARKS", Xsd.STRING).nullable(1).build();
        ColumnInfo attrDef = ColumnFactory.builder("ATTR_DEF", Xsd.STRING).nullable(1).build();
        ColumnInfo sqlDataType = ColumnFactory.builder("SQL_DATA_TYPE", Xsd.INT).nullable(0).build();
        ColumnInfo sqlDateTimeSub = ColumnFactory.builder("SQL_DATETIME_SUB", Xsd.INT).nullable(0).build();
        ColumnInfo charOctetLength = ColumnFactory.builder("CHAR_OCTET_LENGTH", Xsd.INT).nullable(0).build();
        ColumnInfo ordinalPosition = ColumnFactory.builder("ORDINAL_POSITION", Xsd.INT).nullable(0).build();
        ColumnInfo isNullable = ColumnFactory.builder("IS_NULLABLE", Xsd.STRING).nullable(0).build();
        ColumnInfo scope = ColumnFactory.builder("SCOPE", Xsd.SHORT).nullable(0).build();
        ColumnInfo scopeCatalog = ColumnFactory.builder("SCOPE_CATALOG", Xsd.STRING).nullable(1).build();
        ColumnInfo scopeSchema = ColumnFactory.builder("SCOPE_SCHEMA", Xsd.STRING).nullable(1).build();
        ColumnInfo scopeTable = ColumnFactory.builder("SCOPE_TABLE", Xsd.STRING).nullable(1).build();
        ColumnInfo sourceDataType = ColumnFactory.builder("SOURCE_DATA_TYPE", Xsd.SHORT).nullable(1).build();
        ColumnInfo columnName = ColumnFactory.builder("COLUMN_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo columnSize = ColumnFactory.builder("COLUMN_SIZE", Xsd.INT).nullable(0).build();
        ColumnInfo columnDef = ColumnFactory.builder("COLUMN_DEF", Xsd.STRING).nullable(1).build();
        ColumnInfo bufferLength = ColumnFactory.builder("BUFFER_LENGTH", Xsd.INT).nullable(0).build();
        ColumnInfo psuedoColumn = ColumnFactory.builder("PSUEDO_COLUMN", Xsd.SHORT).nullable(0).build();
        ColumnInfo tableCat = ColumnFactory.builder("TABLE_CAT", Xsd.STRING).nullable(1).build();
        ColumnInfo tableCatalog = ColumnFactory.builder("TABLE_CATALOG", Xsd.STRING).nullable(1).build();
        ColumnInfo tableSchema = ColumnFactory.builder("TABLE_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo tableName = ColumnFactory.builder("TABLE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo name = ColumnFactory.builder("NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo maxLen = ColumnFactory.builder("MAX_LEN", Xsd.INT).nullable(0).build();
        ColumnInfo defaultValue = ColumnFactory.builder("DEFAULT_VALUE", Xsd.STRING).nullable(1).build();
        ColumnInfo description = ColumnFactory.builder("DESCRIPTION", Xsd.STRING).nullable(1).build();
        ColumnInfo isAutoIncrement = ColumnFactory.builder("IS_AUTOINCREMENT", Xsd.STRING).nullable(0).build();
        ColumnInfo className = ColumnFactory.builder("CLASS_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo baseType = ColumnFactory.builder("BASE_TYPE", Xsd.SHORT).nullable(1).build();
        ColumnInfo grantor = ColumnFactory.builder("GRANTOR", Xsd.STRING).nullable(1).build();
        ColumnInfo grantee = ColumnFactory.builder("GRANTEE", Xsd.STRING).nullable(1).build();
        ColumnInfo privilege = ColumnFactory.builder("PRIVILEGE", Xsd.STRING).nullable(0).build();
        ColumnInfo isGrantable = ColumnFactory.builder("IS_GRANTABLE", Xsd.STRING).nullable(0).build();
        ColumnInfo pkTableCat = ColumnFactory.builder("PKTABLE_CAT", Xsd.STRING).nullable(1).build();
        ColumnInfo pkTableSchema = ColumnFactory.builder("PKTABLE_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo pkTableName = ColumnFactory.builder("PKTABLE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo pkColumnName = ColumnFactory.builder("PKCOLUMN_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo fkTableCat = ColumnFactory.builder("FKTABLE_CAT", Xsd.STRING).nullable(1).build();
        ColumnInfo fkTableSchema = ColumnFactory.builder("FKTABLE_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo fkTableName = ColumnFactory.builder("FKTABLE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo fkColumnName = ColumnFactory.builder("FKCOLUMN_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo keySeq = ColumnFactory.builder("KEY_SEQ", Xsd.SHORT).nullable(0).build();
        ColumnInfo updateRule = ColumnFactory.builder("UPDATE_RULE", Xsd.SHORT).nullable(0).build();
        ColumnInfo deleteRule = ColumnFactory.builder("DELETE_RULE", Xsd.SHORT).nullable(0).build();
        ColumnInfo fkName = ColumnFactory.builder("FK_NAME", Xsd.STRING).nullable(1).build();
        ColumnInfo pkName = ColumnFactory.builder("PK_NAME", Xsd.STRING).nullable(1).build();
        ColumnInfo deferrability = ColumnFactory.builder("DEFERRABILITY", Xsd.SHORT).nullable(0).build();
        ColumnInfo functionCat = ColumnFactory.builder("FUNCTION_CAT", Xsd.STRING).nullable(1).build();
        ColumnInfo functionSchema = ColumnFactory.builder("FUNCTION_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo functionName = ColumnFactory.builder("FUNCTION_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo columnType = ColumnFactory.builder("COLUMN_TYPE", Xsd.SHORT).nullable(0).build();
        ColumnInfo precision = ColumnFactory.builder("PRECISION", Xsd.INT).nullable(0).build();
        ColumnInfo length = ColumnFactory.builder("LENGTH", Xsd.INT).nullable(0).build();
        ColumnInfo scale = ColumnFactory.builder("SCALE", Xsd.SHORT).nullable(0).build();
        ColumnInfo radix = ColumnFactory.builder("RADIX", Xsd.SHORT).nullable(0).build();
        ColumnInfo specificName = ColumnFactory.builder("SPECIFIC_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo functionType = ColumnFactory.builder("FUNCTION_TYPE", Xsd.SHORT).nullable(0).build();
        ColumnInfo nonUnique = ColumnFactory.builder("NON_UNIQUE", Xsd.BOOLEAN).nullable(0).build();
        ColumnInfo indexQualifier = ColumnFactory.builder("INDEX_QUALIFIER", Xsd.STRING).nullable(1).build();
        ColumnInfo indexName = ColumnFactory.builder("INDEX_NAME", Xsd.STRING).nullable(1).build();
        ColumnInfo type = ColumnFactory.builder("TYPE", Xsd.SHORT).nullable(0).build();
        ColumnInfo ascOrDesc = ColumnFactory.builder("ASC_OR_DESC", Xsd.STRING).nullable(1).build();
        ColumnInfo cardinality = ColumnFactory.builder("CARDINALITY", Xsd.INT).nullable(0).build();
        ColumnInfo pages = ColumnFactory.builder("PAGES", Xsd.INT).nullable(0).build();
        ColumnInfo filterCondition = ColumnFactory.builder("FILTER_CONDITION", Xsd.STRING).nullable(1).build();
        ColumnInfo procedureCat = ColumnFactory.builder("PROCEDURE_CAT", Xsd.STRING).nullable(1).build();
        ColumnInfo procedureSchema = ColumnFactory.builder("PROCEDURE_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo procedureName = ColumnFactory.builder("PROCEDURE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo procedureType = ColumnFactory.builder("PROCEDURE_TYPE", Xsd.SHORT).nullable(0).build();
        ColumnInfo superTableName = ColumnFactory.builder("SUPERTABLE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo superTypeCat = ColumnFactory.builder("SUPERTYPE_CAT", Xsd.STRING).nullable(1).build();
        ColumnInfo superTypeSchema = ColumnFactory.builder("SUPERTYPE_SCHEM", Xsd.STRING).nullable(1).build();
        ColumnInfo superTypeName = ColumnFactory.builder("SUPERTYPE_NAME", Xsd.STRING).nullable(0).build();
        ColumnInfo litPrefix = ColumnFactory.builder("LITERAL_PREFIX", Xsd.STRING).nullable(1).build();
        ColumnInfo litSuffix = ColumnFactory.builder("LITERAL_SUFFIX", Xsd.STRING).nullable(1).build();
        ColumnInfo createParams = ColumnFactory.builder("CREATE_PARAMS", Xsd.STRING).nullable(1).build();
        ColumnInfo caseSensitive = ColumnFactory.builder("CASE_SENSITIVE", Xsd.BOOLEAN).nullable(0).build();
        ColumnInfo searchable = ColumnFactory.builder("SEARCHABLE", Xsd.SHORT).nullable(0).build();
        ColumnInfo unsignedAttr = ColumnFactory.builder("UNSIGNED_ATTRIBUTE", Xsd.BOOLEAN).nullable(0).build();
        ColumnInfo fixedPrecScale = ColumnFactory.builder("FIXED_PREC_SCALE", Xsd.BOOLEAN).nullable(0).build();
        ColumnInfo autoIncrement = ColumnFactory.builder("AUTO_INCREMENT", Xsd.BOOLEAN).nullable(0).build();
        ColumnInfo localTypeName = ColumnFactory.builder("LOCAL_TYPE_NAME", Xsd.STRING).nullable(1).build();
        ColumnInfo minScale = ColumnFactory.builder("MINIMUM_SCALE", Xsd.SHORT).nullable(0).build();
        ColumnInfo maxScale = ColumnFactory.builder("MAXIMUM_SCALE", Xsd.SHORT).nullable(1).build();
        ColumnInfo tableType = ColumnFactory.builder("TABLE_TYPE", Xsd.STRING).nullable(0).build();
        ColumnInfo selfRefColName = ColumnFactory.builder("SELF_REFERENCING_COL_NAME", Xsd.STRING).nullable(1).build();
        ColumnInfo refGeneration = ColumnFactory.builder("REF_GENERATION", Xsd.STRING).nullable(1).build();
        ColumnInfo columnUsage = ColumnFactory.builder("COLUMN_USAGE", Xsd.STRING).nullable(0).build();
        ATTRIBUTE_COLUMNS = new ColumnInfo[]{typeCat, typeSchema, typeName, attrName, dataType, attrTypeName, attrSize, decimalDigits, numPrecRadix, nullable, remarks, attrDef, sqlDataType, sqlDateTimeSub, charOctetLength, ordinalPosition, isNullable, scopeCatalog, scopeSchema, scopeTable, sourceDataType};
        BEST_ROW_IDENTIFIER_COLUMNS = new ColumnInfo[]{scope, columnName, dataType, typeName, columnSize, bufferLength, decimalDigits, psuedoColumn};
        CATALOG_COLUMNS = new ColumnInfo[]{tableCat};
        CLIENT_INFO_PROPERTY_COLUMNS = new ColumnInfo[]{name, maxLen, defaultValue, description};
        COLUMN_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, dataType, typeName, columnSize, bufferLength, decimalDigits, numPrecRadix, nullable, remarks, columnDef, sqlDataType, sqlDateTimeSub, charOctetLength, ordinalPosition, isNullable, scopeCatalog, scopeSchema, scopeTable, sourceDataType, isAutoIncrement};
        COLUMN_PRIVILEGE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, grantor, grantee, privilege, isGrantable};
        CROSS_REFERENCE_COLUMNS = new ColumnInfo[]{pkTableCat, pkTableSchema, pkTableName, pkColumnName, fkTableCat, fkTableSchema, fkTableName, fkColumnName, keySeq, updateRule, deleteRule, fkName, pkName, deferrability};
        EXPORTED_KEY_COLUMNS = new ColumnInfo[]{pkTableCat, pkTableSchema, pkTableName, pkColumnName, fkTableCat, fkTableSchema, fkTableName, fkColumnName, keySeq, updateRule, deleteRule, fkName, pkName, deferrability};
        FUNCTION_COLUMN_COLUMNS = new ColumnInfo[]{functionCat, functionSchema, functionName, columnName, columnType, dataType, typeName, precision, length, scale, radix, shortNullable, remarks, charOctetLength, ordinalPosition, isNullable, specificName};
        FUNCTION_COLUMNS = new ColumnInfo[]{functionCat, functionSchema, functionName, remarks, functionType, specificName};
        IMPORTED_KEY_COLUMNS = new ColumnInfo[]{pkTableCat, pkTableSchema, pkTableName, pkColumnName, fkTableCat, fkTableSchema, fkTableName, fkColumnName, keySeq, updateRule, deleteRule, fkName, pkName, deferrability};
        INDEX_INFO_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, nonUnique, indexQualifier, indexName, type, ordinalPosition, columnName, ascOrDesc, cardinality, pages, filterCondition};
        PRIMARY_KEY_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, keySeq, pkName};
        PROCEDURE_COLUMN_COLUMNS = new ColumnInfo[]{procedureCat, procedureSchema, procedureName, columnName, columnType, dataType, typeName, precision, length, scale, radix, shortNullable, remarks, columnDef, sqlDataType, sqlDateTimeSub, charOctetLength, ordinalPosition, isNullable, specificName};
        PROCEDURE_COLUMNS = new ColumnInfo[]{procedureCat, procedureSchema, procedureName, empty, empty, empty, remarks, procedureType, specificName};
        PSUEDO_COLUMN_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, dataType, columnSize, decimalDigits, numPrecRadix, columnUsage, remarks, charOctetLength, isNullable};
        SCHEMA_COLUMNS = new ColumnInfo[]{tableSchema, tableCatalog};
        SUPER_TABLE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, superTableName};
        SUPER_TYPE_COLUMNS = new ColumnInfo[]{typeCat, typeSchema, typeName, superTypeCat, superTypeSchema, superTypeName};
        TABLE_PRIVILEGE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, grantor, grantee, privilege, isGrantable};
        TABLE_TYPE_COLUMNS = new ColumnInfo[]{tableType};
        TABLE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, tableType, remarks, typeCat, typeSchema, typeName, selfRefColName, refGeneration};
        TYPE_INFO_COLUMNS = new ColumnInfo[]{typeName, dataType, precision, litPrefix, litSuffix, createParams, shortNullable, caseSensitive, searchable, unsignedAttr, fixedPrecScale, autoIncrement, localTypeName, minScale, maxScale, sqlDataType, sqlDateTimeSub, numPrecRadix};
        UDT_COLUMNS = new ColumnInfo[]{typeCat, typeSchema, typeName, className, dataType, remarks, baseType};
        VERSION_COLUMNS = new ColumnInfo[]{scope, columnName, dataType, typeName, columnSize, bufferLength, decimalDigits, psuedoColumn};
    }
}

