/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.metadata;

import world.data.jdbc.internal.metadata.ColumnInfo;
import world.data.jdbc.internal.types.TypeMap;
import world.data.jdbc.internal.types.TypeMapping;
import world.data.jdbc.internal.util.Optionals;
import world.data.jdbc.model.Iri;

public final class ColumnFactory {
    public static ColumnInfo.Builder builder(String label, Iri datatype) {
        TypeMapping custom = TypeMap.INSTANCE.getStandardOrCustom(datatype);
        TypeMapping standard = TypeMap.INSTANCE.getStandard(datatype);
        return ColumnInfo.builder().label(label).typeName(datatype.getIri()).type(custom.getTypeNumber()).className(standard.getJavaType().getName()).scale(Optionals.or(custom.getMaxScale(), 0)).precision(Optionals.or(custom.getPrecision(), 0)).signed(Optionals.or(custom.getSigned(), false));
    }

    private ColumnFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

