/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import world.data.jdbc.internal.transport.BindingsParser;
import world.data.jdbc.internal.transport.ColumnParser;
import world.data.jdbc.internal.transport.ElementParser;
import world.data.jdbc.internal.transport.FieldParser;
import world.data.jdbc.internal.transport.ParserUtil;
import world.data.jdbc.internal.transport.Response;
import world.data.jdbc.internal.transport.StreamParser;

final class SparqlResultsParser
implements StreamParser<Response> {
    SparqlResultsParser() {
    }

    @Override
    public String getAcceptType() {
        return "application/sparql-results+json";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Response parse(InputStream in, String contentType) throws IOException {
        String section;
        JsonParser parser = ParserUtil.JSON_FACTORY.createParser(in);
        List<Object> columns = null;
        ArrayList variables = new ArrayList();
        boolean[] foundVariables = new boolean[]{false};
        boolean foundBindings = false;
        ParserUtil.expect(parser, parser.nextToken(), JsonToken.START_OBJECT);
        block12: while ((section = parser.nextFieldName()) != null) {
            JsonToken sectionToken = parser.nextToken();
            switch (section) {
                case "metadata": {
                    if (sectionToken != JsonToken.START_ARRAY) break;
                    columns = new ColumnParser(parser).parseArray();
                    break;
                }
                case "head": {
                    if (sectionToken != JsonToken.START_OBJECT) break;
                    FieldParser.parseObject(parser, (headField, headToken) -> {
                        if ("vars".equals(headField) && headToken == JsonToken.START_ARRAY) {
                            ElementParser.parseArray(parser, token -> {
                                if (token.isScalarValue()) {
                                    variables.add(parser.getText());
                                }
                            });
                            foundVariables[0] = true;
                        }
                    });
                    break;
                }
                case "results": {
                    String resultsField;
                    if (sectionToken != JsonToken.START_OBJECT) break;
                    while ((resultsField = parser.nextFieldName()) != null) {
                        JsonToken resultsToken = parser.nextToken();
                        if ("bindings".equals(resultsField) && resultsToken == JsonToken.START_ARRAY) {
                            foundBindings = true;
                            break block12;
                        }
                        parser.skipChildren();
                    }
                    ParserUtil.expect(parser, parser.getCurrentToken(), JsonToken.END_OBJECT);
                    break;
                }
                case "boolean": {
                    boolean askResult = parser.getBooleanValue();
                    while (parser.nextToken() != null && parser.getCurrentToken().isStructEnd()) {
                    }
                    parser.close();
                    return Response.builder().booleanResult(askResult).build();
                }
            }
            parser.skipChildren();
        }
        if (!foundVariables[0]) {
            throw new JsonParseException(parser, "Missing required 'head.vars' array in result set response.");
        }
        if (!foundBindings) {
            throw new JsonParseException(parser, "Missing required 'results.bindings' array in result set response.");
        }
        if (columns != null && columns.size() != variables.size()) {
            throw new JsonParseException(parser, "Expected 'metadata' and 'head.vars' arrays to have the same number of elements.");
        }
        if (columns == null) {
            columns = new ArrayList();
            for (String variable : variables) {
                columns.add(Response.Column.builder().index(columns.size()).name(variable).build());
            }
        }
        LinkedHashMap<String, Response.Column> columnsByVar = new LinkedHashMap<String, Response.Column>();
        int i = 0;
        while (true) {
            if (i >= variables.size()) {
                BindingsParser rows = new BindingsParser(parser, columnsByVar);
                return Response.builder().columns(columns).rows(rows).cleanup((AutoCloseable)parser).build();
            }
            columnsByVar.put((String)variables.get(i), (Response.Column)columns.get(i));
            ++i;
        }
    }
}

