/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

final class ParserUtil {
    static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES).enable(JsonParser.Feature.ALLOW_COMMENTS);

    static void expect(JsonParser parser, JsonToken actual, JsonToken expected) throws JsonParseException {
        if (actual != expected) {
            throw new JsonParseException(parser, String.format("Expected %s, found %s", expected, actual));
        }
    }

    static <T> T require(JsonParser parser, T value, String property) throws JsonParseException {
        if (value == null) {
            throw new JsonParseException(parser, String.format("Missing required '%s' property", property));
        }
        return value;
    }

    private ParserUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

