/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import world.data.jdbc.internal.transport.NodeParser;
import world.data.jdbc.internal.transport.ParserUtil;
import world.data.jdbc.internal.transport.Response;
import world.data.jdbc.internal.util.AbstractIterator;
import world.data.jdbc.model.Node;

final class BindingsParser
extends AbstractIterator<Node[]> {
    private final JsonParser parser;
    private final Map<String, Response.Column> columnsByVar;
    private final NodeParser nodeParser;

    BindingsParser(JsonParser parser, Map<String, Response.Column> columnsByVar) throws IOException {
        this.parser = Objects.requireNonNull(parser, "parser");
        this.columnsByVar = Objects.requireNonNull(columnsByVar, "columnsByVar");
        this.nodeParser = NodeParser.forSparqlResults(parser);
        ParserUtil.expect(parser, parser.getCurrentToken(), JsonToken.START_ARRAY);
    }

    @Override
    protected Node[] computeNext() {
        try {
            while (this.parser.nextToken() == JsonToken.START_OBJECT) {
                Node[] nodes = this.nodeParser.parseRow(this.columnsByVar);
                if (nodes == null) continue;
                return nodes;
            }
            while (this.parser.hasCurrentToken() && this.parser.getCurrentToken().isStructEnd()) {
                this.parser.nextToken();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (Node[])this.endOfData();
    }
}

