/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.model;

import java.util.Objects;
import java.util.UUID;
import world.data.jdbc.internal.types.NTriplesFormat;
import world.data.jdbc.model.Node;

public final class Blank
implements Node {
    private final String label;

    public static Blank unique() {
        return new Blank(UUID.randomUUID().toString());
    }

    public Blank(String label) {
        this.label = Objects.requireNonNull(label, "label");
        if (!NTriplesFormat.isWellFormedLabel(label)) {
            throw new IllegalArgumentException("Invalid blank node label: " + label);
        }
    }

    @Override
    public String toString() {
        return NTriplesFormat.formatBlank(this.label);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Blank)) {
            return false;
        }
        Blank other = (Blank)o;
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }
}

