/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.util.Iterator;
import java.util.Objects;

public final class PeekingIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private boolean hasPeeked;
    private T peeked;

    public PeekingIterator(Iterator<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public boolean hasNext() {
        return this.hasPeeked || this.delegate.hasNext();
    }

    public T peek() {
        if (!this.hasPeeked) {
            this.peeked = this.delegate.next();
            this.hasPeeked = true;
        }
        return this.peeked;
    }

    @Override
    public T next() {
        if (this.hasPeeked) {
            T result = this.peeked;
            this.hasPeeked = false;
            this.peeked = null;
            return result;
        }
        return this.delegate.next();
    }
}

