/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Like {
    private static final Pattern PART = Pattern.compile("(%+|_|[^%_]+)");

    static boolean matches(String string, String pattern) {
        if ("%".equals(pattern) || string.equals(pattern)) {
            return true;
        }
        return Like.toRegex(pattern).matcher(string).matches();
    }

    private static Pattern toRegex(String pattern) {
        StringBuilder buf = new StringBuilder();
        Matcher matcher = PART.matcher(pattern);
        block8: while (matcher.find()) {
            String part;
            switch (part = matcher.group(1)) {
                case "%": {
                    buf.append(".*");
                    continue block8;
                }
                case "_": {
                    buf.append('.');
                    continue block8;
                }
            }
            buf.append(Pattern.quote(part));
        }
        return Pattern.compile(buf.toString(), 32);
    }

    private Like() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

