/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.types;

import java.sql.JDBCType;
import javax.annotation.Nonnull;
import world.data.jdbc.model.Iri;

public class TypeMapping {
    @Nonnull
    private final Iri datatype;
    @Nonnull
    private final JDBCType jdbcType;
    @Nonnull
    private final Class<?> javaType;
    private final int precision;
    private final Integer minScale;
    private final Integer maxScale;
    private final Boolean signed;
    private final Boolean fixedPrecisionScale;

    static TypeMapping simple(Iri datatype, JDBCType jdbcType, Class<?> javaType, int columnSize) {
        return new TypeMapping(datatype, jdbcType, javaType, columnSize, null, null, null, null);
    }

    static TypeMapping numeric(Iri datatype, JDBCType jdbcType, Class<?> javaType, int precision, int minScale, int maxScale, boolean signed, boolean fixedPrecisionScale) {
        return new TypeMapping(datatype, jdbcType, javaType, precision, minScale, maxScale, signed, fixedPrecisionScale);
    }

    public int getTypeNumber() {
        return this.jdbcType.getVendorTypeNumber();
    }

    public boolean isNumeric() {
        return this.signed != null;
    }

    @Nonnull
    public Iri getDatatype() {
        return this.datatype;
    }

    @Nonnull
    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    @Nonnull
    public Class<?> getJavaType() {
        return this.javaType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public Integer getMinScale() {
        return this.minScale;
    }

    public Integer getMaxScale() {
        return this.maxScale;
    }

    public Boolean getSigned() {
        return this.signed;
    }

    public Boolean getFixedPrecisionScale() {
        return this.fixedPrecisionScale;
    }

    private TypeMapping(@Nonnull Iri datatype, @Nonnull JDBCType jdbcType, @Nonnull Class<?> javaType, int precision, Integer minScale, Integer maxScale, Boolean signed, Boolean fixedPrecisionScale) {
        if (datatype == null) {
            throw new NullPointerException("datatype");
        }
        if (jdbcType == null) {
            throw new NullPointerException("jdbcType");
        }
        if (javaType == null) {
            throw new NullPointerException("javaType");
        }
        this.datatype = datatype;
        this.jdbcType = jdbcType;
        this.javaType = javaType;
        this.precision = precision;
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.signed = signed;
        this.fixedPrecisionScale = fixedPrecisionScale;
    }
}

