/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import world.data.jdbc.internal.transport.NodeParser;
import world.data.jdbc.internal.transport.ParserUtil;
import world.data.jdbc.internal.util.AbstractIterator;
import world.data.jdbc.model.Blank;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Node;

final class TriplesParser
extends AbstractIterator<Node[]> {
    private final JsonParser parser;
    private final NodeParser objectParser;
    private int level;
    private Node subject;
    private Node predicate;

    TriplesParser(JsonParser parser) throws IOException {
        this.parser = Objects.requireNonNull(parser, "parser");
        this.objectParser = NodeParser.forRdf(parser);
    }

    @Override
    protected Node[] computeNext() {
        try {
            while (true) {
                block1 : switch (this.level) {
                    case 3: {
                        JsonToken subjectToken;
                        while ((subjectToken = this.parser.nextToken()) != JsonToken.END_ARRAY) {
                            if (subjectToken == JsonToken.START_OBJECT) {
                                Node object = this.objectParser.parse();
                                ParserUtil.expect(this.parser, this.parser.getCurrentToken(), JsonToken.END_OBJECT);
                                if (this.subject == null || this.predicate == null || object == null) {
                                    throw new IllegalStateException();
                                }
                                return new Node[]{this.subject, this.predicate, object};
                            }
                            this.parser.skipChildren();
                        }
                        this.predicate = null;
                        this.level = 2;
                    }
                    case 2: {
                        String predicateString;
                        while ((predicateString = this.parser.nextFieldName()) != null) {
                            if (this.parser.nextToken() == JsonToken.START_ARRAY) {
                                this.predicate = this.parseSubjectOrPredicate(predicateString);
                                this.level = 3;
                                break block1;
                            }
                            this.parser.skipChildren();
                        }
                        ParserUtil.expect(this.parser, this.parser.getCurrentToken(), JsonToken.END_OBJECT);
                        this.subject = null;
                        this.level = 1;
                    }
                    case 1: {
                        String subjectString;
                        while ((subjectString = this.parser.nextFieldName()) != null) {
                            if (this.parser.nextToken() == JsonToken.START_OBJECT) {
                                this.subject = this.parseSubjectOrPredicate(subjectString);
                                this.level = 2;
                                break block1;
                            }
                            this.parser.skipChildren();
                        }
                        ParserUtil.expect(this.parser, this.parser.getCurrentToken(), JsonToken.END_OBJECT);
                        this.level = 0;
                    }
                    case 0: {
                        if (this.parser.nextToken() == JsonToken.START_OBJECT) {
                            this.level = 1;
                            break;
                        }
                        return (Node[])this.endOfData();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Node parseSubjectOrPredicate(String string) {
        if (string.startsWith("_:")) {
            return new Blank(string.substring(2));
        }
        return new Iri(string);
    }
}

