/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import world.data.jdbc.internal.transport.FieldParser;
import world.data.jdbc.internal.transport.ParserUtil;
import world.data.jdbc.internal.transport.StreamParser;

final class ErrorMessageParser
implements StreamParser<String> {
    private String message;

    ErrorMessageParser() {
    }

    @Override
    public String getAcceptType() {
        return "*/*";
    }

    @Override
    public String parse(InputStream in, String contentType) throws Exception {
        if ("text/html".equals(contentType)) {
            return null;
        }
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(1);
        int firstChar = in.read();
        in.reset();
        if (firstChar == 123) {
            return this.parseJson(in);
        }
        return this.parsePlainText(in);
    }

    private String parseJson(InputStream in) throws IOException {
        this.message = null;
        try (JsonParser parser = ParserUtil.JSON_FACTORY.createParser(in);){
            ParserUtil.expect(parser, parser.nextToken(), JsonToken.START_OBJECT);
            FieldParser.parseObject(parser, (field, token) -> {
                if ("message".equals(field)) {
                    this.message = parser.getText();
                }
            });
        }
        return this.message;
    }

    private String parsePlainText(InputStream in) throws IOException {
        return this.readString(in, StandardCharsets.UTF_8).trim();
    }

    private String readString(InputStream in, Charset charset) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.copy(in, buf);
        return buf.toString(charset.name());
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] b = new byte[4096];
        while ((len = in.read(b)) != -1) {
            out.write(b, 0, len);
        }
    }
}

