/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.transport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import world.data.jdbc.internal.transport.ElementParser;
import world.data.jdbc.internal.transport.FieldParser;
import world.data.jdbc.internal.transport.ParserUtil;
import world.data.jdbc.internal.transport.Response;

final class ColumnParser {
    private final JsonParser parser;
    private String name;

    ColumnParser(JsonParser parser) {
        this.parser = Objects.requireNonNull(parser, "parser");
    }

    List<Response.Column> parseArray() throws IOException {
        ArrayList<Response.Column> columns = new ArrayList<Response.Column>();
        ElementParser.parseArray(this.parser, metadataToken -> {
            if (metadataToken == JsonToken.START_OBJECT) {
                columns.add(this.parse(columns.size()));
            }
        });
        return columns;
    }

    private Response.Column parse(int index) throws IOException {
        Response.Column.Builder builder = Response.Column.builder().index(index);
        this.name = null;
        FieldParser.parseObject(this.parser, (field, token) -> {
            switch (field) {
                case "name": {
                    ParserUtil.expect(this.parser, token, JsonToken.VALUE_STRING);
                    this.name = this.parser.getText();
                    builder.name(this.name);
                    break;
                }
                case "description": {
                    builder.description(this.parser.getText());
                    break;
                }
                case "type": {
                    builder.datatypeIri(this.parser.getText());
                    break;
                }
                case "formatString": {
                    builder.formatString(this.parser.getText());
                    break;
                }
                case "units": {
                    builder.units(this.parser.getText());
                    break;
                }
                case "scalingFactor": {
                    if (!token.isScalarValue()) break;
                    builder.scalingFactor(this.parser.getValueAsDouble());
                }
            }
        });
        ParserUtil.require(this.parser, this.name, "name");
        return builder.build();
    }
}

