/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.results;

import java.sql.ResultSet;
import java.sql.SQLException;
import world.data.jdbc.internal.util.Conditions;

interface ForwardOnlyResultSet
extends ResultSet {
    @Override
    default public int getType() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        return 1003;
    }

    @Override
    default public int getFetchDirection() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        return 1000;
    }

    @Override
    default public void setFetchDirection(int direction) throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        Conditions.check(direction == 1000, "Result Set is forward-only");
    }

    @Override
    default public int getRow() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean isBeforeFirst() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean isAfterLast() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean isFirst() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean isLast() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public void beforeFirst() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public void afterLast() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean first() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean last() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean absolute(int row) throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean relative(int rows) throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public boolean previous() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }

    @Override
    default public void refreshRow() throws SQLException {
        Conditions.check(!this.isClosed(), "Result Set is closed");
        throw new SQLException("Result Set is forward-only");
    }
}

